/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import androidx.annotation.NonNull;
import io.noties.markwon.ext.latex.JLatexMathBlock;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

class JLatexMathBlockParser
extends AbstractBlockParser {
    private static final char DOLLAR = '$';
    private static final char SPACE = ' ';
    private final JLatexMathBlock block = new JLatexMathBlock();
    private final StringBuilder builder = new StringBuilder();
    private final int signs;

    JLatexMathBlockParser(int signs) {
        this.signs = signs;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState parserState) {
        int nextNonSpaceIndex = parserState.getNextNonSpaceIndex();
        CharSequence line = parserState.getLine();
        int length = line.length();
        if (parserState.getIndent() < Parsing.CODE_BLOCK_INDENT && JLatexMathBlockParser.consume('$', line, nextNonSpaceIndex, length) == this.signs && Parsing.skip((char)' ', (CharSequence)line, (int)(nextNonSpaceIndex + this.signs), (int)length) == length) {
            return BlockContinue.finished();
        }
        return BlockContinue.atIndex((int)parserState.getIndex());
    }

    public void addLine(CharSequence line) {
        this.builder.append(line);
        this.builder.append('\n');
    }

    public void closeBlock() {
        this.block.latex(this.builder.toString());
    }

    private static int consume(char c, @NonNull CharSequence line, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (c == line.charAt(i)) continue;
            return i - start;
        }
        return end - start;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int length;
            int indent = state.getIndent();
            if (indent >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int nextNonSpaceIndex = state.getNextNonSpaceIndex();
            CharSequence line = state.getLine();
            int signs = JLatexMathBlockParser.consume('$', line, nextNonSpaceIndex, length = line.length());
            if (signs < 2) {
                return BlockStart.none();
            }
            if (Parsing.skip((char)' ', (CharSequence)line, (int)(nextNonSpaceIndex + signs), (int)length) != length) {
                return BlockStart.none();
            }
            return BlockStart.of((BlockParser[])new BlockParser[]{new JLatexMathBlockParser(signs)}).atIndex(length + 1);
        }
    }
}

