/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.ImageSizeResolver;

class JLatexBlockImageSizeResolver
extends ImageSizeResolver {
    private final boolean fitCanvas;

    JLatexBlockImageSizeResolver(boolean fitCanvas) {
        this.fitCanvas = fitCanvas;
    }

    @NonNull
    public Rect resolveImageSize(@NonNull AsyncDrawable drawable) {
        Rect imageBounds = drawable.getResult().getBounds();
        int canvasWidth = drawable.getLastKnownCanvasWidth();
        if (this.fitCanvas) {
            int w = imageBounds.width();
            if (w < canvasWidth) {
                return new Rect(0, 0, canvasWidth, imageBounds.height());
            }
            if (w > canvasWidth) {
                float ratio = (float)w / (float)imageBounds.height();
                int h = (int)((float)canvasWidth / ratio + 0.5f);
                return new Rect(0, 0, canvasWidth, h);
            }
        }
        return imageBounds;
    }
}

