/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.editor;

import android.text.Spannable;
import android.text.Spanned;
import android.util.Log;
import androidx.annotation.NonNull;
import io.noties.markwon.editor.MarkwonEditorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class PersistedSpans {
    @NonNull
    public abstract <T> T get(@NonNull Class<T> var1);

    abstract void removeUnused();

    @NonNull
    static Provider provider() {
        return new Provider();
    }

    static class Impl
    extends PersistedSpans {
        private final Spannable spannable;
        private final Map<Class<?>, SpanFactory> spans;
        private final Map<Class<?>, List<Object>> map;

        Impl(@NonNull Spannable spannable, @NonNull Map<Class<?>, SpanFactory> spans) {
            this.spannable = spannable;
            this.spans = spans;
            this.map = MarkwonEditorUtils.extractSpans((Spanned)spannable, spans.keySet());
        }

        @Override
        @NonNull
        public <T> T get(@NonNull Class<T> type) {
            Object span;
            List<Object> list = this.map.get(type);
            if (list != null && list.size() > 0) {
                span = list.remove(0);
            } else {
                SpanFactory spanFactory = this.spans.get(type);
                if (spanFactory == null) {
                    throw new IllegalStateException("Requested type `" + type.getName() + "` was not registered, use PersistedSpans.Builder#persistSpan method to register");
                }
                span = spanFactory.create();
            }
            return (T)span;
        }

        @Override
        void removeUnused() {
            for (List<Object> spans : this.map.values()) {
                if (spans == null || spans.size() <= 0) continue;
                for (Object span : spans) {
                    this.spannable.removeSpan(span);
                }
            }
        }
    }

    static class Provider
    implements Builder {
        private final Map<Class<?>, SpanFactory> map = new HashMap(3);

        Provider() {
        }

        @Override
        @NonNull
        public <T> Builder persistSpan(@NonNull Class<T> type, @NonNull SpanFactory<T> spanFactory) {
            if (this.map.put(type, spanFactory) != null) {
                Log.e((String)"MD-EDITOR", (String)String.format(Locale.ROOT, "Re-declaration of persisted span for '%s'", type.getName()));
            }
            return this;
        }

        @NonNull
        PersistedSpans provide(@NonNull Spannable spannable) {
            return new Impl(spannable, this.map);
        }
    }

    public static interface Builder {
        @NonNull
        public <T> Builder persistSpan(@NonNull Class<T> var1, @NonNull SpanFactory<T> var2);
    }

    public static interface SpanFactory<T> {
        @NonNull
        public T create();
    }
}

