/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.editor;

import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MarkwonEditorUtils {
    @NonNull
    public static Map<Class<?>, List<Object>> extractSpans(@NonNull Spanned spanned, @NonNull Collection<Class<?>> types) {
        Object[] spans = spanned.getSpans(0, spanned.length(), Object.class);
        HashMap map = new HashMap(3);
        for (Object span : spans) {
            Class<?> type = span.getClass();
            if (!types.contains(type)) continue;
            ArrayList<Object> list = (ArrayList<Object>)map.get(type);
            if (list == null) {
                list = new ArrayList<Object>(3);
                map.put(type, list);
            }
            list.add(span);
        }
        return map;
    }

    @Nullable
    public static Match findDelimited(@NonNull String input, int startFrom, @NonNull String delimiter) {
        int length;
        int end;
        int start = input.indexOf(delimiter, startFrom);
        if (start > -1 && (end = input.indexOf(delimiter, start + (length = delimiter.length()))) > -1) {
            return new MatchImpl(delimiter, start, end + length);
        }
        return null;
    }

    @Nullable
    public static Match findDelimited(@NonNull String input, int start, @NonNull String delimiter1, @NonNull String delimiter2) {
        int l1 = delimiter1.length();
        int l2 = delimiter2.length();
        char c1 = delimiter1.charAt(0);
        char c2 = delimiter2.charAt(0);
        char previousC = '\u0000';
        int length = input.length();
        for (int i = start; i < length; ++i) {
            Match match;
            char c = input.charAt(i);
            if (c == previousC) continue;
            if (c == c1 ? (match = MarkwonEditorUtils.matchDelimiter(input, i, length, delimiter1, l1)) != null : c == c2 && (match = MarkwonEditorUtils.matchDelimiter(input, i, length, delimiter2, l2)) != null) {
                return match;
            }
            previousC = c;
        }
        return null;
    }

    @Nullable
    private static Match matchDelimiter(@NonNull String input, int start, int length, @NonNull String delimiter, int delimiterLength) {
        if (start + delimiterLength < length) {
            int end;
            boolean result = true;
            for (int i = 1; i < delimiterLength; ++i) {
                if (input.charAt(start + i) == delimiter.charAt(i)) continue;
                result = false;
                break;
            }
            if (result && (end = input.indexOf(delimiter, start + delimiterLength)) > -1 && end - start > delimiterLength) {
                return new MatchImpl(delimiter, start, end + delimiterLength);
            }
        }
        return null;
    }

    private MarkwonEditorUtils() {
    }

    private static class MatchImpl
    implements Match {
        private final String delimiter;
        private final int start;
        private final int end;

        MatchImpl(@NonNull String delimiter, int start, int end) {
            this.delimiter = delimiter;
            this.start = start;
            this.end = end;
        }

        @Override
        @NonNull
        public String delimiter() {
            return this.delimiter;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @NonNull
        public String toString() {
            return "MatchImpl{delimiter='" + this.delimiter + '\'' + ", start=" + this.start + ", end=" + this.end + '}';
        }
    }

    public static interface Match {
        @NonNull
        public String delimiter();

        public int start();

        public int end();
    }
}

