/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.SystemClock;
import android.text.Spanned;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.R;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableSpan;

public abstract class AsyncDrawableScheduler {
    public static void schedule(final @NonNull TextView textView) {
        Integer lastTextHashCode = (Integer)textView.getTag(R.id.markwon_drawables_scheduler_last_text_hashcode);
        int textHashCode = textView.getText().hashCode();
        if (lastTextHashCode != null && lastTextHashCode == textHashCode) {
            return;
        }
        textView.setTag(R.id.markwon_drawables_scheduler_last_text_hashcode, (Object)textHashCode);
        AsyncDrawableSpan[] spans = AsyncDrawableScheduler.extractSpans(textView);
        if (spans != null && spans.length > 0) {
            if (textView.getTag(R.id.markwon_drawables_scheduler) == null) {
                View.OnAttachStateChangeListener listener = new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                    }

                    public void onViewDetachedFromWindow(View v) {
                        AsyncDrawableScheduler.unschedule(textView);
                        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        v.setTag(R.id.markwon_drawables_scheduler, null);
                    }
                };
                textView.addOnAttachStateChangeListener(listener);
                textView.setTag(R.id.markwon_drawables_scheduler, (Object)listener);
            }
            TextViewInvalidator invalidator = new TextViewInvalidator(textView);
            for (AsyncDrawableSpan span : spans) {
                AsyncDrawable drawable = span.getDrawable();
                drawable.setCallback2(new DrawableCallbackImpl(textView, invalidator, drawable.getBounds()));
            }
        }
    }

    public static void unschedule(@NonNull TextView view) {
        if (view.getTag(R.id.markwon_drawables_scheduler_last_text_hashcode) == null) {
            return;
        }
        view.setTag(R.id.markwon_drawables_scheduler_last_text_hashcode, null);
        AsyncDrawableSpan[] spans = AsyncDrawableScheduler.extractSpans(view);
        if (spans != null && spans.length > 0) {
            for (AsyncDrawableSpan span : spans) {
                span.getDrawable().setCallback2(null);
            }
        }
    }

    @Nullable
    private static AsyncDrawableSpan[] extractSpans(@NonNull TextView textView) {
        int length;
        CharSequence cs = textView.getText();
        int n = length = cs != null ? cs.length() : 0;
        if (length == 0 || !(cs instanceof Spanned)) {
            return null;
        }
        return (AsyncDrawableSpan[])((Spanned)cs).getSpans(0, length, AsyncDrawableSpan.class);
    }

    private AsyncDrawableScheduler() {
    }

    private static class TextViewInvalidator
    implements DrawableCallbackImpl.Invalidator,
    Runnable {
        private final TextView textView;

        TextViewInvalidator(@NonNull TextView textView) {
            this.textView = textView;
        }

        @Override
        public void invalidate() {
            this.textView.removeCallbacks((Runnable)this);
            this.textView.post((Runnable)this);
        }

        @Override
        public void run() {
            this.textView.setText(this.textView.getText());
        }
    }

    private static class DrawableCallbackImpl
    implements Drawable.Callback {
        private final TextView view;
        private final Invalidator invalidator;
        private Rect previousBounds;

        DrawableCallbackImpl(@NonNull TextView view, @NonNull Invalidator invalidator, Rect initialBounds) {
            this.view = view;
            this.invalidator = invalidator;
            this.previousBounds = new Rect(initialBounds);
        }

        public void invalidateDrawable(final @NonNull Drawable who) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        DrawableCallbackImpl.this.invalidateDrawable(who);
                    }
                });
                return;
            }
            Rect rect = who.getBounds();
            if (!this.previousBounds.equals((Object)rect)) {
                this.invalidator.invalidate();
                this.previousBounds = new Rect(rect);
            } else {
                this.view.postInvalidate();
            }
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
            long delay = when - SystemClock.uptimeMillis();
            this.view.postDelayed(what, delay);
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
            this.view.removeCallbacks(what);
        }

        static interface Invalidator {
            public void invalidate();
        }
    }
}

