/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.Size;
import io.noties.markwon.utils.ColorUtils;
import io.noties.markwon.utils.Dip;
import java.util.Arrays;
import java.util.Locale;

public class MarkwonTheme {
    protected static final int BLOCK_QUOTE_DEF_COLOR_ALPHA = 25;
    protected static final int CODE_DEF_BACKGROUND_COLOR_ALPHA = 25;
    protected static final float CODE_DEF_TEXT_SIZE_RATIO = 0.87f;
    protected static final int HEADING_DEF_BREAK_COLOR_ALPHA = 75;
    private static final float[] HEADING_SIZES = new float[]{2.0f, 1.5f, 1.17f, 1.0f, 0.83f, 0.67f};
    protected static final int THEMATIC_BREAK_DEF_ALPHA = 25;
    protected final int linkColor;
    protected final boolean isLinkedUnderlined;
    protected final int blockMargin;
    protected final int blockQuoteWidth;
    protected final int blockQuoteColor;
    protected final int listItemColor;
    protected final int bulletListItemStrokeWidth;
    protected final int bulletWidth;
    protected final int codeTextColor;
    protected final int codeBlockTextColor;
    protected final int codeBackgroundColor;
    protected final int codeBlockBackgroundColor;
    protected final int codeBlockMargin;
    protected final Typeface codeTypeface;
    protected final Typeface codeBlockTypeface;
    protected final int codeTextSize;
    protected final int codeBlockTextSize;
    protected final int headingBreakHeight;
    protected final int headingBreakColor;
    protected final Typeface headingTypeface;
    protected final float[] headingTextSizeMultipliers;
    protected final int thematicBreakColor;
    protected final int thematicBreakHeight;

    @NonNull
    public static MarkwonTheme create(@NonNull Context context) {
        return MarkwonTheme.builderWithDefaults(context).build();
    }

    @NonNull
    public static Builder emptyBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull MarkwonTheme copyFrom) {
        return new Builder(copyFrom);
    }

    @NonNull
    public static Builder builderWithDefaults(@NonNull Context context) {
        Dip dip = Dip.create(context);
        return new Builder().codeBlockMargin(dip.toPx(8)).blockMargin(dip.toPx(24)).blockQuoteWidth(dip.toPx(4)).bulletListItemStrokeWidth(dip.toPx(1)).headingBreakHeight(dip.toPx(1)).thematicBreakHeight(dip.toPx(4));
    }

    protected MarkwonTheme(@NonNull Builder builder) {
        this.linkColor = builder.linkColor;
        this.isLinkedUnderlined = builder.isLinkUnderlined;
        this.blockMargin = builder.blockMargin;
        this.blockQuoteWidth = builder.blockQuoteWidth;
        this.blockQuoteColor = builder.blockQuoteColor;
        this.listItemColor = builder.listItemColor;
        this.bulletListItemStrokeWidth = builder.bulletListItemStrokeWidth;
        this.bulletWidth = builder.bulletWidth;
        this.codeTextColor = builder.codeTextColor;
        this.codeBlockTextColor = builder.codeBlockTextColor;
        this.codeBackgroundColor = builder.codeBackgroundColor;
        this.codeBlockBackgroundColor = builder.codeBlockBackgroundColor;
        this.codeBlockMargin = builder.codeBlockMargin;
        this.codeTypeface = builder.codeTypeface;
        this.codeBlockTypeface = builder.codeBlockTypeface;
        this.codeTextSize = builder.codeTextSize;
        this.codeBlockTextSize = builder.codeBlockTextSize;
        this.headingBreakHeight = builder.headingBreakHeight;
        this.headingBreakColor = builder.headingBreakColor;
        this.headingTypeface = builder.headingTypeface;
        this.headingTextSizeMultipliers = builder.headingTextSizeMultipliers;
        this.thematicBreakColor = builder.thematicBreakColor;
        this.thematicBreakHeight = builder.thematicBreakHeight;
    }

    public void applyLinkStyle(@NonNull TextPaint paint) {
        paint.setUnderlineText(this.isLinkedUnderlined);
        if (this.linkColor != 0) {
            paint.setColor(this.linkColor);
        } else {
            paint.setColor(paint.linkColor);
        }
    }

    public void applyLinkStyle(@NonNull Paint paint) {
        paint.setUnderlineText(this.isLinkedUnderlined);
        if (this.linkColor != 0) {
            paint.setColor(this.linkColor);
        } else if (paint instanceof TextPaint) {
            paint.setColor(((TextPaint)paint).linkColor);
        }
    }

    public void applyBlockQuoteStyle(@NonNull Paint paint) {
        int color = this.blockQuoteColor == 0 ? ColorUtils.applyAlpha(paint.getColor(), 25) : this.blockQuoteColor;
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(color);
    }

    public int getBlockMargin() {
        return this.blockMargin;
    }

    public int getBlockQuoteWidth() {
        int out = this.blockQuoteWidth == 0 ? (int)((float)this.blockMargin * 0.25f + 0.5f) : this.blockQuoteWidth;
        return out;
    }

    public void applyListItemStyle(@NonNull Paint paint) {
        int color = this.listItemColor != 0 ? this.listItemColor : paint.getColor();
        paint.setColor(color);
        if (this.bulletListItemStrokeWidth != 0) {
            paint.setStrokeWidth((float)this.bulletListItemStrokeWidth);
        }
    }

    public int getBulletWidth(int height) {
        int min = Math.min(this.blockMargin, height) / 2;
        int width = this.bulletWidth == 0 || this.bulletWidth > min ? min : this.bulletWidth;
        return width;
    }

    public void applyCodeTextStyle(@NonNull Paint paint) {
        if (this.codeTextColor != 0) {
            paint.setColor(this.codeTextColor);
        }
        if (this.codeTypeface != null) {
            paint.setTypeface(this.codeTypeface);
            if (this.codeTextSize > 0) {
                paint.setTextSize((float)this.codeTextSize);
            }
        } else {
            paint.setTypeface(Typeface.MONOSPACE);
            if (this.codeTextSize > 0) {
                paint.setTextSize((float)this.codeTextSize);
            } else {
                paint.setTextSize(paint.getTextSize() * 0.87f);
            }
        }
    }

    public void applyCodeBlockTextStyle(@NonNull Paint paint) {
        Typeface typeface;
        int textColor;
        int n = textColor = this.codeBlockTextColor != 0 ? this.codeBlockTextColor : this.codeTextColor;
        if (textColor != 0) {
            paint.setColor(textColor);
        }
        Typeface typeface2 = typeface = this.codeBlockTypeface != null ? this.codeBlockTypeface : this.codeTypeface;
        if (typeface != null) {
            int textSize;
            paint.setTypeface(typeface);
            int n2 = textSize = this.codeBlockTextSize > 0 ? this.codeBlockTextSize : this.codeTextSize;
            if (textSize > 0) {
                paint.setTextSize((float)textSize);
            }
        } else {
            int textSize;
            paint.setTypeface(Typeface.MONOSPACE);
            int n3 = textSize = this.codeBlockTextSize > 0 ? this.codeBlockTextSize : this.codeTextSize;
            if (textSize > 0) {
                paint.setTextSize((float)textSize);
            } else {
                paint.setTextSize(paint.getTextSize() * 0.87f);
            }
        }
    }

    public int getCodeBlockMargin() {
        return this.codeBlockMargin;
    }

    public int getCodeBackgroundColor(@NonNull Paint paint) {
        int color = this.codeBackgroundColor != 0 ? this.codeBackgroundColor : ColorUtils.applyAlpha(paint.getColor(), 25);
        return color;
    }

    public int getCodeBlockBackgroundColor(@NonNull Paint paint) {
        int color = this.codeBlockBackgroundColor != 0 ? this.codeBlockBackgroundColor : this.codeBackgroundColor;
        return color != 0 ? color : ColorUtils.applyAlpha(paint.getColor(), 25);
    }

    public void applyHeadingTextStyle(@NonNull Paint paint, @IntRange(from=1L, to=6L) int level) {
        float[] textSizes;
        if (this.headingTypeface == null) {
            paint.setFakeBoldText(true);
        } else {
            paint.setTypeface(this.headingTypeface);
        }
        float[] fArray = textSizes = this.headingTextSizeMultipliers != null ? this.headingTextSizeMultipliers : HEADING_SIZES;
        if (textSizes == null || textSizes.length < level) {
            throw new IllegalStateException(String.format(Locale.US, "Supplied heading level: %d is invalid, where configured heading sizes are: `%s`", level, Arrays.toString(textSizes)));
        }
        paint.setTextSize(paint.getTextSize() * textSizes[level - 1]);
    }

    public void applyHeadingBreakStyle(@NonNull Paint paint) {
        int color = this.headingBreakColor != 0 ? this.headingBreakColor : ColorUtils.applyAlpha(paint.getColor(), 75);
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        if (this.headingBreakHeight >= 0) {
            paint.setStrokeWidth((float)this.headingBreakHeight);
        }
    }

    public void applyThematicBreakStyle(@NonNull Paint paint) {
        int color = this.thematicBreakColor != 0 ? this.thematicBreakColor : ColorUtils.applyAlpha(paint.getColor(), 25);
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        if (this.thematicBreakHeight >= 0) {
            paint.setStrokeWidth((float)this.thematicBreakHeight);
        }
    }

    public static class Builder {
        private int linkColor;
        private boolean isLinkUnderlined = true;
        private int blockMargin;
        private int blockQuoteWidth;
        private int blockQuoteColor;
        private int listItemColor;
        private int bulletListItemStrokeWidth;
        private int bulletWidth;
        private int codeTextColor;
        private int codeBlockTextColor;
        private int codeBackgroundColor;
        private int codeBlockBackgroundColor;
        private int codeBlockMargin;
        private Typeface codeTypeface;
        private Typeface codeBlockTypeface;
        private int codeTextSize;
        private int codeBlockTextSize;
        private int headingBreakHeight = -1;
        private int headingBreakColor;
        private Typeface headingTypeface;
        private float[] headingTextSizeMultipliers;
        private int thematicBreakColor;
        private int thematicBreakHeight = -1;

        Builder() {
        }

        Builder(@NonNull MarkwonTheme theme) {
            this.linkColor = theme.linkColor;
            this.isLinkUnderlined = theme.isLinkedUnderlined;
            this.blockMargin = theme.blockMargin;
            this.blockQuoteWidth = theme.blockQuoteWidth;
            this.blockQuoteColor = theme.blockQuoteColor;
            this.listItemColor = theme.listItemColor;
            this.bulletListItemStrokeWidth = theme.bulletListItemStrokeWidth;
            this.bulletWidth = theme.bulletWidth;
            this.codeTextColor = theme.codeTextColor;
            this.codeBlockTextColor = theme.codeBlockTextColor;
            this.codeBackgroundColor = theme.codeBackgroundColor;
            this.codeBlockBackgroundColor = theme.codeBlockBackgroundColor;
            this.codeBlockMargin = theme.codeBlockMargin;
            this.codeTypeface = theme.codeTypeface;
            this.codeTextSize = theme.codeTextSize;
            this.headingBreakHeight = theme.headingBreakHeight;
            this.headingBreakColor = theme.headingBreakColor;
            this.headingTypeface = theme.headingTypeface;
            this.headingTextSizeMultipliers = theme.headingTextSizeMultipliers;
            this.thematicBreakColor = theme.thematicBreakColor;
            this.thematicBreakHeight = theme.thematicBreakHeight;
        }

        @NonNull
        public Builder linkColor(@ColorInt int linkColor) {
            this.linkColor = linkColor;
            return this;
        }

        @NonNull
        public Builder isLinkUnderlined(boolean isLinkUnderlined) {
            this.isLinkUnderlined = isLinkUnderlined;
            return this;
        }

        @NonNull
        public Builder blockMargin(@Px int blockMargin) {
            this.blockMargin = blockMargin;
            return this;
        }

        @NonNull
        public Builder blockQuoteWidth(@Px int blockQuoteWidth) {
            this.blockQuoteWidth = blockQuoteWidth;
            return this;
        }

        @NonNull
        public Builder blockQuoteColor(@ColorInt int blockQuoteColor) {
            this.blockQuoteColor = blockQuoteColor;
            return this;
        }

        @NonNull
        public Builder listItemColor(@ColorInt int listItemColor) {
            this.listItemColor = listItemColor;
            return this;
        }

        @NonNull
        public Builder bulletListItemStrokeWidth(@Px int bulletListItemStrokeWidth) {
            this.bulletListItemStrokeWidth = bulletListItemStrokeWidth;
            return this;
        }

        @NonNull
        public Builder bulletWidth(@Px int bulletWidth) {
            this.bulletWidth = bulletWidth;
            return this;
        }

        @NonNull
        public Builder codeTextColor(@ColorInt int codeTextColor) {
            this.codeTextColor = codeTextColor;
            return this;
        }

        @NonNull
        public Builder codeBlockTextColor(@ColorInt int codeBlockTextColor) {
            this.codeBlockTextColor = codeBlockTextColor;
            return this;
        }

        @NonNull
        public Builder codeBackgroundColor(@ColorInt int codeBackgroundColor) {
            this.codeBackgroundColor = codeBackgroundColor;
            return this;
        }

        @NonNull
        public Builder codeBlockBackgroundColor(@ColorInt int codeBlockBackgroundColor) {
            this.codeBlockBackgroundColor = codeBlockBackgroundColor;
            return this;
        }

        @NonNull
        public Builder codeBlockMargin(@Px int codeBlockMargin) {
            this.codeBlockMargin = codeBlockMargin;
            return this;
        }

        @NonNull
        public Builder codeTypeface(@NonNull Typeface codeTypeface) {
            this.codeTypeface = codeTypeface;
            return this;
        }

        @NonNull
        public Builder codeBlockTypeface(@NonNull Typeface typeface) {
            this.codeBlockTypeface = typeface;
            return this;
        }

        @NonNull
        public Builder codeTextSize(@Px int codeTextSize) {
            this.codeTextSize = codeTextSize;
            return this;
        }

        @NonNull
        public Builder codeBlockTextSize(@Px int codeTextSize) {
            this.codeBlockTextSize = codeTextSize;
            return this;
        }

        @NonNull
        public Builder headingBreakHeight(@Px int headingBreakHeight) {
            this.headingBreakHeight = headingBreakHeight;
            return this;
        }

        @NonNull
        public Builder headingBreakColor(@ColorInt int headingBreakColor) {
            this.headingBreakColor = headingBreakColor;
            return this;
        }

        @NonNull
        public Builder headingTypeface(@NonNull Typeface headingTypeface) {
            this.headingTypeface = headingTypeface;
            return this;
        }

        @NonNull
        public Builder headingTextSizeMultipliers(@Size(value=6L) @NonNull float[] headingTextSizeMultipliers) {
            this.headingTextSizeMultipliers = headingTextSizeMultipliers;
            return this;
        }

        @NonNull
        public Builder thematicBreakColor(@ColorInt int thematicBreakColor) {
            this.thematicBreakColor = thematicBreakColor;
            return this;
        }

        @NonNull
        public Builder thematicBreakHeight(@Px int thematicBreakHeight) {
            this.thematicBreakHeight = thematicBreakHeight;
            return this;
        }

        @NonNull
        public MarkwonTheme build() {
            return new MarkwonTheme(this);
        }
    }
}

