/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.providers;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.app.ActivityCompat;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.location.LocationProvider;
import io.nlopez.smartlocation.location.LocationStore;
import io.nlopez.smartlocation.location.config.LocationAccuracy;
import io.nlopez.smartlocation.location.config.LocationParams;
import io.nlopez.smartlocation.utils.Logger;

public class LocationManagerProvider
implements LocationProvider,
LocationListener {
    private static final String LOCATIONMANAGERPROVIDER_ID = "LMP";
    private LocationManager locationManager;
    private OnLocationUpdatedListener listener;
    private LocationStore locationStore;
    private Logger logger;
    private Context mContext;

    @Override
    public void init(Context context, Logger logger) {
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.logger = logger;
        this.mContext = context;
        this.locationStore = new LocationStore(context);
    }

    @Override
    public void start(OnLocationUpdatedListener listener, LocationParams params, boolean singleUpdate) {
        this.listener = listener;
        if (listener == null) {
            this.logger.d("Listener is null, you sure about this?", new Object[0]);
        }
        Criteria criteria = this.getProvider(params);
        if (singleUpdate) {
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                this.logger.i("Permission check failed. Please handle it in your app before setting up location", new Object[0]);
                return;
            }
            this.locationManager.requestSingleUpdate(criteria, (LocationListener)this, Looper.getMainLooper());
        } else {
            this.locationManager.requestLocationUpdates(params.getInterval(), params.getDistance(), criteria, (LocationListener)this, Looper.getMainLooper());
        }
    }

    @Override
    public void stop() {
        if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        this.locationManager.removeUpdates((LocationListener)this);
    }

    @Override
    public Location getLastLocation() {
        Location location;
        if (this.locationManager != null) {
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return null;
            }
            location = this.locationManager.getLastKnownLocation("gps");
            if (location != null) {
                return location;
            }
        }
        if ((location = this.locationStore.get(LOCATIONMANAGERPROVIDER_ID)) != null) {
            return location;
        }
        return null;
    }

    private Criteria getProvider(LocationParams params) {
        LocationAccuracy accuracy = params.getAccuracy();
        Criteria criteria = new Criteria();
        switch (accuracy) {
            case HIGH: {
                criteria.setAccuracy(1);
                criteria.setHorizontalAccuracy(3);
                criteria.setVerticalAccuracy(3);
                criteria.setBearingAccuracy(3);
                criteria.setSpeedAccuracy(3);
                criteria.setPowerRequirement(3);
                break;
            }
            case MEDIUM: {
                criteria.setAccuracy(2);
                criteria.setHorizontalAccuracy(2);
                criteria.setVerticalAccuracy(2);
                criteria.setBearingAccuracy(2);
                criteria.setSpeedAccuracy(2);
                criteria.setPowerRequirement(2);
                break;
            }
            default: {
                criteria.setAccuracy(2);
                criteria.setHorizontalAccuracy(1);
                criteria.setVerticalAccuracy(1);
                criteria.setBearingAccuracy(1);
                criteria.setSpeedAccuracy(1);
                criteria.setPowerRequirement(1);
            }
        }
        return criteria;
    }

    public void onLocationChanged(Location location) {
        this.logger.d("onLocationChanged", location);
        if (this.listener != null) {
            this.listener.onLocationUpdated(location);
        }
        if (this.locationStore != null) {
            this.logger.d("Stored in SharedPreferences", new Object[0]);
            this.locationStore.put(LOCATIONMANAGERPROVIDER_ID, location);
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }
}

