/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.providers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.location.LocationStore;
import io.nlopez.smartlocation.location.ServiceLocationProvider;
import io.nlopez.smartlocation.location.config.LocationParams;
import io.nlopez.smartlocation.utils.GooglePlayServicesListener;
import io.nlopez.smartlocation.utils.Logger;
import io.nlopez.smartlocation.utils.ServiceConnectionListener;

public class LocationGooglePlayServicesProvider
implements ServiceLocationProvider,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener,
ResultCallback<Status> {
    public static final int REQUEST_START_LOCATION_FIX = 10001;
    public static final int REQUEST_CHECK_SETTINGS = 20001;
    private static final String GMS_ID = "GMS";
    private GoogleApiClient client;
    private Logger logger;
    private OnLocationUpdatedListener listener;
    private boolean shouldStart = false;
    private boolean stopped = false;
    private LocationStore locationStore;
    private LocationRequest locationRequest;
    private Context context;
    private GooglePlayServicesListener googlePlayServicesListener;
    private ServiceConnectionListener serviceListener;
    private boolean checkLocationSettings = false;
    private boolean fulfilledCheckLocationSettings = false;
    private boolean alwaysShow = true;
    private ResultCallback<LocationSettingsResult> settingsResultCallback = new ResultCallback<LocationSettingsResult>(){

        public void onResult(LocationSettingsResult locationSettingsResult) {
            Status status = locationSettingsResult.getStatus();
            switch (status.getStatusCode()) {
                case 0: {
                    LocationGooglePlayServicesProvider.this.logger.d("All location settings are satisfied.", new Object[0]);
                    LocationGooglePlayServicesProvider.this.fulfilledCheckLocationSettings = true;
                    LocationGooglePlayServicesProvider.this.startUpdating(LocationGooglePlayServicesProvider.this.locationRequest);
                    break;
                }
                case 6: {
                    LocationGooglePlayServicesProvider.this.logger.w("Location settings are not satisfied. Show the user a dialog to upgrade location settings. You should hook into the Activity onActivityResult and call this provider's onActivityResult method for continuing this call flow. ", new Object[0]);
                    if (LocationGooglePlayServicesProvider.this.context instanceof Activity) {
                        try {
                            status.startResolutionForResult((Activity)LocationGooglePlayServicesProvider.this.context, 20001);
                        }
                        catch (IntentSender.SendIntentException e) {
                            LocationGooglePlayServicesProvider.this.logger.i("PendingIntent unable to execute request.", new Object[0]);
                        }
                        break;
                    }
                    LocationGooglePlayServicesProvider.this.logger.w("Provided context is not the context of an activity, therefore we can't launch the resolution activity.", new Object[0]);
                    break;
                }
                case 8502: {
                    LocationGooglePlayServicesProvider.this.logger.i("Location settings are inadequate, and cannot be fixed here. Dialog not created.", new Object[0]);
                    LocationGooglePlayServicesProvider.this.stop();
                }
            }
        }
    };

    public LocationGooglePlayServicesProvider() {
    }

    public LocationGooglePlayServicesProvider(GooglePlayServicesListener playServicesListener) {
        this();
        this.googlePlayServicesListener = playServicesListener;
    }

    public LocationGooglePlayServicesProvider(ServiceConnectionListener serviceListener) {
        this();
        this.serviceListener = serviceListener;
    }

    @Override
    public void init(Context context, Logger logger) {
        this.logger = logger;
        this.context = context;
        this.locationStore = new LocationStore(context);
        if (!this.shouldStart) {
            this.client = new GoogleApiClient.Builder(context).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
            this.client.connect();
        } else {
            logger.d("already started", new Object[0]);
        }
    }

    private LocationRequest createRequest(LocationParams params, boolean singleUpdate) {
        LocationRequest request = LocationRequest.create().setFastestInterval(params.getInterval()).setInterval(params.getInterval()).setSmallestDisplacement(params.getDistance());
        switch (params.getAccuracy()) {
            case HIGH: {
                request.setPriority(100);
                break;
            }
            case MEDIUM: {
                request.setPriority(102);
                break;
            }
            case LOW: {
                request.setPriority(104);
                break;
            }
            case LOWEST: {
                request.setPriority(105);
            }
        }
        if (singleUpdate) {
            request.setNumUpdates(1);
        }
        return request;
    }

    @Override
    public void start(OnLocationUpdatedListener listener, LocationParams params, boolean singleUpdate) {
        this.listener = listener;
        if (listener == null) {
            this.logger.d("Listener is null, you sure about this?", new Object[0]);
        }
        this.locationRequest = this.createRequest(params, singleUpdate);
        if (this.client.isConnected()) {
            this.startUpdating(this.locationRequest);
        } else if (this.stopped) {
            this.shouldStart = true;
            this.client.connect();
            this.stopped = false;
        } else {
            this.shouldStart = true;
            this.logger.d("still not connected - scheduled start when connection is ok", new Object[0]);
        }
    }

    private void startUpdating(LocationRequest request) {
        if (this.checkLocationSettings && !this.fulfilledCheckLocationSettings) {
            this.logger.d("startUpdating wont be executed for now, as we have to test the location settings before", new Object[0]);
            this.checkLocationSettings();
            return;
        }
        if (this.client.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                this.logger.i("Permission check failed. Please handle it in your app before setting up location", new Object[0]);
                return;
            }
            LocationServices.FusedLocationApi.requestLocationUpdates(this.client, request, (LocationListener)this, Looper.getMainLooper()).setResultCallback((ResultCallback)this);
        } else {
            this.logger.w("startUpdating executed without the GoogleApiClient being connected!!", new Object[0]);
        }
    }

    private void checkLocationSettings() {
        LocationSettingsRequest request = new LocationSettingsRequest.Builder().setAlwaysShow(this.alwaysShow).addLocationRequest(this.locationRequest).build();
        LocationServices.SettingsApi.checkLocationSettings(this.client, request).setResultCallback(this.settingsResultCallback);
    }

    @Override
    public void stop() {
        this.logger.d("stop", new Object[0]);
        if (this.client.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.client, (LocationListener)this);
            this.client.disconnect();
        }
        this.fulfilledCheckLocationSettings = false;
        this.shouldStart = false;
        this.stopped = true;
    }

    @Override
    public Location getLastLocation() {
        if (this.client != null && this.client.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return null;
            }
            Location location = LocationServices.FusedLocationApi.getLastLocation(this.client);
            if (location != null) {
                return location;
            }
        }
        if (this.locationStore != null) {
            return this.locationStore.get(GMS_ID);
        }
        return null;
    }

    @Override
    public ServiceConnectionListener getServiceListener() {
        return this.serviceListener;
    }

    @Override
    public void setServiceListener(ServiceConnectionListener listener) {
        this.serviceListener = listener;
    }

    public void onConnected(Bundle bundle) {
        this.logger.d("onConnected", new Object[0]);
        if (this.shouldStart) {
            this.startUpdating(this.locationRequest);
        }
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnected(bundle);
        }
        if (this.serviceListener != null) {
            this.serviceListener.onConnected();
        }
    }

    public void onConnectionSuspended(int i) {
        this.logger.d("onConnectionSuspended " + i, new Object[0]);
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnectionSuspended(i);
        }
        if (this.serviceListener != null) {
            this.serviceListener.onConnectionSuspended();
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.logger.d("onConnectionFailed " + connectionResult.toString(), new Object[0]);
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnectionFailed(connectionResult);
        }
        if (this.serviceListener != null) {
            this.serviceListener.onConnectionFailed();
        }
    }

    public void onLocationChanged(Location location) {
        this.logger.d("onLocationChanged", location);
        if (this.listener != null) {
            this.listener.onLocationUpdated(location);
        }
        if (this.locationStore != null) {
            this.logger.d("Stored in SharedPreferences", new Object[0]);
            this.locationStore.put(GMS_ID, location);
        }
    }

    public void onResult(Status status) {
        if (status.isSuccess()) {
            this.logger.d("Locations update request successful", new Object[0]);
        } else if (status.hasResolution() && this.context instanceof Activity) {
            this.logger.w("Unable to register, but we can solve this - will startActivityForResult. You should hook into the Activity onActivityResult and call this provider's onActivityResult method for continuing this call flow.", new Object[0]);
            try {
                status.startResolutionForResult((Activity)this.context, 10001);
            }
            catch (IntentSender.SendIntentException e) {
                this.logger.e(e, "problem with startResolutionForResult", new Object[0]);
            }
        } else {
            this.logger.e("Registering failed: " + status.getStatusMessage(), new Object[0]);
        }
    }

    public boolean isCheckingLocationSettings() {
        return this.checkLocationSettings;
    }

    public void setCheckLocationSettings(boolean allowingLocationSettings) {
        this.checkLocationSettings = allowingLocationSettings;
    }

    public void setLocationSettingsAlwaysShow(boolean alwaysShow) {
        this.alwaysShow = alwaysShow;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 20001) {
            switch (resultCode) {
                case -1: {
                    this.logger.i("User agreed to make required location settings changes.", new Object[0]);
                    this.fulfilledCheckLocationSettings = true;
                    this.startUpdating(this.locationRequest);
                    break;
                }
                case 0: {
                    this.logger.i("User chose not to make required location settings changes.", new Object[0]);
                    this.stop();
                }
            }
        } else if (requestCode == 10001) {
            switch (resultCode) {
                case -1: {
                    this.logger.i("User fixed the problem.", new Object[0]);
                    this.startUpdating(this.locationRequest);
                    break;
                }
                case 0: {
                    this.logger.i("User chose not to fix the problem.", new Object[0]);
                    this.stop();
                }
            }
        }
    }
}

