/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.config;

import io.nlopez.smartlocation.location.config.LocationAccuracy;

public class LocationParams {
    public static final LocationParams NAVIGATION = new Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(500L).build();
    public static final LocationParams BEST_EFFORT = new Builder().setAccuracy(LocationAccuracy.MEDIUM).setDistance(150.0f).setInterval(2500L).build();
    public static final LocationParams LAZY = new Builder().setAccuracy(LocationAccuracy.LOW).setDistance(500.0f).setInterval(5000L).build();
    private long interval;
    private float distance;
    private LocationAccuracy accuracy;

    LocationParams(LocationAccuracy accuracy, long interval, float distance) {
        this.interval = interval;
        this.distance = distance;
        this.accuracy = accuracy;
    }

    public long getInterval() {
        return this.interval;
    }

    public float getDistance() {
        return this.distance;
    }

    public LocationAccuracy getAccuracy() {
        return this.accuracy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationParams)) {
            return false;
        }
        LocationParams that = (LocationParams)o;
        return Float.compare(that.distance, this.distance) == 0 && this.interval == that.interval && this.accuracy == that.accuracy;
    }

    public int hashCode() {
        int result = (int)(this.interval ^ this.interval >>> 32);
        result = 31 * result + (this.distance != 0.0f ? Float.floatToIntBits(this.distance) : 0);
        result = 31 * result + this.accuracy.hashCode();
        return result;
    }

    public static class Builder {
        private LocationAccuracy accuracy;
        private long interval;
        private float distance;

        public Builder setAccuracy(LocationAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder setDistance(float distance) {
            this.distance = distance;
            return this;
        }

        public LocationParams build() {
            return new LocationParams(this.accuracy, this.interval, this.distance);
        }
    }
}

