/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.geofencing.providers;

import android.app.Activity;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.LocationServices;
import io.nlopez.smartlocation.OnGeofencingTransitionListener;
import io.nlopez.smartlocation.geofencing.GeofencingProvider;
import io.nlopez.smartlocation.geofencing.GeofencingStore;
import io.nlopez.smartlocation.geofencing.model.GeofenceModel;
import io.nlopez.smartlocation.geofencing.utils.TransitionGeofence;
import io.nlopez.smartlocation.utils.GooglePlayServicesListener;
import io.nlopez.smartlocation.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeofencingGooglePlayServicesProvider
implements GeofencingProvider,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
ResultCallback<Status> {
    public static final int RESULT_CODE = 10003;
    public static final String BROADCAST_INTENT_ACTION = GeofencingGooglePlayServicesProvider.class.getCanonicalName() + ".GEOFENCE_TRANSITION";
    public static final String GEOFENCES_EXTRA_ID = "geofences";
    public static final String TRANSITION_EXTRA_ID = "transition";
    public static final String LOCATION_EXTRA_ID = "location";
    private final List<Geofence> geofencesToAdd = Collections.synchronizedList(new ArrayList());
    private final List<String> geofencesToRemove = Collections.synchronizedList(new ArrayList());
    private GoogleApiClient client;
    private Logger logger;
    private OnGeofencingTransitionListener listener;
    private GeofencingStore geofencingStore;
    private Context context;
    private PendingIntent pendingIntent;
    private boolean stopped = false;
    private final GooglePlayServicesListener googlePlayServicesListener;
    private BroadcastReceiver geofencingReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (BROADCAST_INTENT_ACTION.equals(intent.getAction()) && intent.hasExtra(GeofencingGooglePlayServicesProvider.GEOFENCES_EXTRA_ID)) {
                GeofencingGooglePlayServicesProvider.this.logger.d("Received geofencing event", new Object[0]);
                int transitionType = intent.getIntExtra(GeofencingGooglePlayServicesProvider.TRANSITION_EXTRA_ID, -1);
                ArrayList geofencingIds = intent.getStringArrayListExtra(GeofencingGooglePlayServicesProvider.GEOFENCES_EXTRA_ID);
                for (String geofenceId : geofencingIds) {
                    GeofenceModel geofenceModel = GeofencingGooglePlayServicesProvider.this.geofencingStore.get(geofenceId);
                    if (geofenceModel != null) {
                        GeofencingGooglePlayServicesProvider.this.listener.onGeofenceTransition(new TransitionGeofence(geofenceModel, transitionType));
                        continue;
                    }
                    GeofencingGooglePlayServicesProvider.this.logger.w("Tried to retrieve geofence " + geofenceId + " but it was not in the store", new Object[0]);
                }
            }
        }
    };

    public GeofencingGooglePlayServicesProvider() {
        this(null);
    }

    public GeofencingGooglePlayServicesProvider(GooglePlayServicesListener playServicesListener) {
        this.googlePlayServicesListener = playServicesListener;
    }

    @Override
    public void init(@NonNull Context context, Logger logger) {
        this.context = context;
        this.logger = logger;
        this.geofencingStore = new GeofencingStore(context);
        this.client = new GoogleApiClient.Builder(context).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.client.connect();
        this.pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)new Intent(context, GeofencingService.class), (int)0x8000000);
    }

    @Override
    public void addGeofence(GeofenceModel geofence) {
        ArrayList<GeofenceModel> wrapperList = new ArrayList<GeofenceModel>();
        wrapperList.add(geofence);
        this.addGeofences(wrapperList);
    }

    @Override
    public void addGeofences(List<GeofenceModel> geofenceList) {
        ArrayList<Geofence> convertedGeofences = new ArrayList<Geofence>();
        for (GeofenceModel geofenceModel : geofenceList) {
            this.geofencingStore.put(geofenceModel.getRequestId(), geofenceModel);
            convertedGeofences.add(geofenceModel.toGeofence());
        }
        if (this.client.isConnected()) {
            if (this.geofencesToAdd.size() > 0) {
                convertedGeofences.addAll(this.geofencesToAdd);
                this.geofencesToAdd.clear();
            }
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                return;
            }
            LocationServices.GeofencingApi.addGeofences(this.client, convertedGeofences, this.pendingIntent);
        } else {
            for (GeofenceModel geofenceModel : geofenceList) {
                this.geofencesToAdd.add(geofenceModel.toGeofence());
            }
        }
    }

    @Override
    public void removeGeofence(String geofenceId) {
        ArrayList<String> wrapperList = new ArrayList<String>();
        wrapperList.add(geofenceId);
        this.removeGeofences(wrapperList);
    }

    @Override
    public void removeGeofences(List<String> geofenceIds) {
        for (String id : geofenceIds) {
            this.geofencingStore.remove(id);
        }
        if (this.client.isConnected()) {
            if (this.geofencesToRemove.size() > 0) {
                geofenceIds.addAll(this.geofencesToRemove);
                this.geofencesToRemove.clear();
            }
            LocationServices.GeofencingApi.removeGeofences(this.client, geofenceIds);
        } else {
            this.geofencesToRemove.addAll(geofenceIds);
        }
    }

    @Override
    public void start(OnGeofencingTransitionListener listener) {
        this.listener = listener;
        IntentFilter intentFilter = new IntentFilter(BROADCAST_INTENT_ACTION);
        this.context.registerReceiver(this.geofencingReceiver, intentFilter);
        if (!this.client.isConnected()) {
            this.logger.d("still not connected - scheduled start when connection is ok", new Object[0]);
        } else if (this.stopped) {
            this.client.connect();
            this.stopped = false;
        }
    }

    @Override
    public void stop() {
        this.logger.d("stop", new Object[0]);
        if (this.client.isConnected()) {
            this.client.disconnect();
        }
        try {
            this.context.unregisterReceiver(this.geofencingReceiver);
        }
        catch (IllegalArgumentException e) {
            this.logger.d("Silenced 'receiver not registered' stuff (calling stop more times than necessary did this)", new Object[0]);
        }
        this.stopped = true;
    }

    public void onConnected(Bundle bundle) {
        this.logger.d("onConnected", new Object[0]);
        if (this.client.isConnected()) {
            if (this.geofencesToAdd.size() > 0) {
                if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                    return;
                }
                LocationServices.GeofencingApi.addGeofences(this.client, this.geofencesToAdd, this.pendingIntent);
                this.geofencesToAdd.clear();
            }
            if (this.geofencesToRemove.size() > 0) {
                LocationServices.GeofencingApi.removeGeofences(this.client, this.geofencesToRemove);
                this.geofencesToRemove.clear();
            }
        }
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnected(bundle);
        }
    }

    public void onConnectionSuspended(int i) {
        this.logger.d("onConnectionSuspended " + i, new Object[0]);
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnectionSuspended(i);
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.logger.d("onConnectionFailed", new Object[0]);
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnectionFailed(connectionResult);
        }
    }

    public void onResult(@NonNull Status status) {
        if (status.isSuccess()) {
            this.logger.d("Geofencing update request successful", new Object[0]);
        } else if (status.hasResolution() && this.context instanceof Activity) {
            this.logger.w("Unable to register, but we can solve this - will startActivityForResult expecting result code 10003 (if received, please try again)", new Object[0]);
            try {
                status.startResolutionForResult((Activity)this.context, 10003);
            }
            catch (IntentSender.SendIntentException e) {
                this.logger.e(e, "problem with startResolutionForResult", new Object[0]);
            }
        } else {
            this.logger.e("Registering failed: " + status.getStatusMessage(), new Object[0]);
        }
    }

    public static class GeofencingService
    extends IntentService {
        public GeofencingService() {
            super(GeofencingService.class.getSimpleName());
        }

        protected void onHandleIntent(Intent intent) {
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
            if (geofencingEvent != null && !geofencingEvent.hasError()) {
                int transition = geofencingEvent.getGeofenceTransition();
                Intent geofenceIntent = new Intent(BROADCAST_INTENT_ACTION);
                geofenceIntent.putExtra(GeofencingGooglePlayServicesProvider.TRANSITION_EXTRA_ID, transition);
                geofenceIntent.putExtra(GeofencingGooglePlayServicesProvider.LOCATION_EXTRA_ID, (Parcelable)geofencingEvent.getTriggeringLocation());
                ArrayList<String> geofencingIds = new ArrayList<String>();
                for (Geofence geofence : geofencingEvent.getTriggeringGeofences()) {
                    geofencingIds.add(geofence.getRequestId());
                }
                geofenceIntent.putStringArrayListExtra(GeofencingGooglePlayServicesProvider.GEOFENCES_EXTRA_ID, geofencingIds);
                this.sendBroadcast(geofenceIntent);
            }
        }
    }
}

