/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.geofencing.model;

import com.google.android.gms.location.Geofence;

public class GeofenceModel {
    private String requestId;
    private double latitude;
    private double longitude;
    private float radius;
    private long expiration;
    private int transition;
    private int loiteringDelay;

    private GeofenceModel(String id, double latitude, double longitude, float radius, long expiration, int transition, int loiteringDelay) {
        this.requestId = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
        this.expiration = expiration;
        this.transition = transition;
        this.loiteringDelay = loiteringDelay;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getRadius() {
        return this.radius;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public int getTransition() {
        return this.transition;
    }

    public int getLoiteringDelay() {
        return this.loiteringDelay;
    }

    public Geofence toGeofence() {
        return new Geofence.Builder().setCircularRegion(this.latitude, this.longitude, this.radius).setExpirationDuration(this.expiration).setRequestId(this.requestId).setTransitionTypes(this.transition).setLoiteringDelay(this.loiteringDelay).build();
    }

    public static class Builder {
        private String requestId;
        private double latitude;
        private double longitude;
        private float radius;
        private long expiration;
        private int transition;
        private int loiteringDelay;

        public Builder(String id) {
            this.requestId = id;
        }

        public Builder setLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder setLongitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder setExpiration(long expiration) {
            this.expiration = expiration;
            return this;
        }

        public Builder setTransition(int transition) {
            this.transition = transition;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelay) {
            this.loiteringDelay = loiteringDelay;
            return this;
        }

        public GeofenceModel build() {
            return new GeofenceModel(this.requestId, this.latitude, this.longitude, this.radius, this.expiration, this.transition, this.loiteringDelay);
        }
    }
}

