/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.geocoding.utils;

import android.location.Address;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;

public class LocationAddress
implements Parcelable {
    private Location location;
    private Address address;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public LocationAddress createFromParcel(Parcel in) {
            return new LocationAddress(in);
        }

        public LocationAddress[] newArray(int size) {
            return new LocationAddress[size];
        }
    };

    public LocationAddress(Address address) {
        this.address = address;
        this.location = new Location(LocationAddress.class.getCanonicalName());
        this.location.setLatitude(address.getLatitude());
        this.location.setLongitude(address.getLongitude());
    }

    public LocationAddress(Parcel in) {
        this.location = (Location)in.readParcelable(Location.class.getClassLoader());
        this.address = (Address)in.readParcelable(Address.class.getClassLoader());
    }

    public Location getLocation() {
        return this.location;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getFormattedAddress() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= this.address.getMaxAddressLineIndex(); ++i) {
            builder.append(this.address.getAddressLine(i));
        }
        return builder.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.location, flags);
        dest.writeParcelable((Parcelable)this.address, flags);
    }
}

