/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.geocoding.providers;

import android.app.IntentService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.os.Parcelable;
import io.nlopez.smartlocation.OnGeocodingListener;
import io.nlopez.smartlocation.OnReverseGeocodingListener;
import io.nlopez.smartlocation.geocoding.GeocodingProvider;
import io.nlopez.smartlocation.geocoding.utils.LocationAddress;
import io.nlopez.smartlocation.utils.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class AndroidGeocodingProvider
implements GeocodingProvider {
    private static final String BROADCAST_DIRECT_GEOCODING_ACTION = AndroidGeocodingProvider.class.getCanonicalName() + ".DIRECT_GEOCODE_ACTION";
    private static final String BROADCAST_REVERSE_GEOCODING_ACTION = AndroidGeocodingProvider.class.getCanonicalName() + ".REVERSE_GEOCODE_ACTION";
    private static final String DIRECT_GEOCODING_ID = "direct";
    private static final String REVERSE_GEOCODING_ID = "reverse";
    private static final String LOCALE_ID = "locale";
    private static final String NAME_ID = "name";
    private static final String LOCATION_ID = "location";
    private static final String RESULT_ID = "result";
    private Locale locale;
    private OnGeocodingListener geocodingListener;
    private OnReverseGeocodingListener reverseGeocodingListener;
    private HashMap<String, Integer> fromNameList;
    private HashMap<Location, Integer> fromLocationList;
    private Context context;
    private Logger logger;
    private BroadcastReceiver directReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (BROADCAST_DIRECT_GEOCODING_ACTION.equals(intent.getAction())) {
                AndroidGeocodingProvider.this.logger.d("sending new direct geocoding response", new Object[0]);
                if (AndroidGeocodingProvider.this.geocodingListener != null) {
                    String name = intent.getStringExtra(AndroidGeocodingProvider.NAME_ID);
                    ArrayList results = intent.getParcelableArrayListExtra(AndroidGeocodingProvider.RESULT_ID);
                    AndroidGeocodingProvider.this.geocodingListener.onLocationResolved(name, results);
                }
            }
        }
    };
    private BroadcastReceiver reverseReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (BROADCAST_REVERSE_GEOCODING_ACTION.equals(intent.getAction())) {
                AndroidGeocodingProvider.this.logger.d("sending new reverse geocoding response", new Object[0]);
                if (AndroidGeocodingProvider.this.reverseGeocodingListener != null) {
                    Location location = (Location)intent.getParcelableExtra(AndroidGeocodingProvider.LOCATION_ID);
                    ArrayList results = (ArrayList)intent.getSerializableExtra(AndroidGeocodingProvider.RESULT_ID);
                    AndroidGeocodingProvider.this.reverseGeocodingListener.onAddressResolved(location, results);
                }
            }
        }
    };

    public AndroidGeocodingProvider() {
        this(Locale.getDefault());
    }

    public AndroidGeocodingProvider(Locale locale) {
        if (locale == null) {
            throw new RuntimeException("Locale is null");
        }
        this.locale = locale;
        this.fromNameList = new HashMap();
        this.fromLocationList = new HashMap();
        if (!Geocoder.isPresent()) {
            throw new RuntimeException("Android Geocoder not present. Please check if Geocoder.isPresent() before invoking the search");
        }
    }

    @Override
    public void init(Context context, Logger logger) {
        this.logger = logger;
        this.context = context;
    }

    @Override
    public void addName(String name, int maxResults) {
        this.fromNameList.put(name, maxResults);
    }

    @Override
    public void addLocation(Location location, int maxResults) {
        this.fromLocationList.put(location, maxResults);
    }

    @Override
    public void start(OnGeocodingListener geocodingListener, OnReverseGeocodingListener reverseGeocodingListener) {
        this.geocodingListener = geocodingListener;
        this.reverseGeocodingListener = reverseGeocodingListener;
        if (this.fromNameList.isEmpty() && this.fromLocationList.isEmpty()) {
            this.logger.w("No direct geocoding or reverse geocoding points added", new Object[0]);
        } else {
            IntentFilter directFilter = new IntentFilter(BROADCAST_DIRECT_GEOCODING_ACTION);
            IntentFilter reverseFilter = new IntentFilter(BROADCAST_REVERSE_GEOCODING_ACTION);
            Intent serviceIntent = new Intent(this.context, AndroidGeocodingService.class);
            serviceIntent.putExtra(LOCALE_ID, (Serializable)this.locale);
            if (!this.fromNameList.isEmpty()) {
                this.context.registerReceiver(this.directReceiver, directFilter);
                serviceIntent.putExtra(DIRECT_GEOCODING_ID, this.fromNameList);
            }
            if (!this.fromLocationList.isEmpty()) {
                this.context.registerReceiver(this.reverseReceiver, reverseFilter);
                serviceIntent.putExtra(REVERSE_GEOCODING_ID, this.fromLocationList);
            }
            this.context.startService(serviceIntent);
            this.fromNameList.clear();
            this.fromLocationList.clear();
        }
    }

    @Override
    public void stop() {
        try {
            this.context.unregisterReceiver(this.directReceiver);
        }
        catch (IllegalArgumentException e) {
            this.logger.d("Silenced 'receiver not registered' stuff (calling stop more times than necessary did this)", new Object[0]);
        }
        try {
            this.context.unregisterReceiver(this.reverseReceiver);
        }
        catch (IllegalArgumentException e) {
            this.logger.d("Silenced 'receiver not registered' stuff (calling stop more times than necessary did this)", new Object[0]);
        }
    }

    public static class AndroidGeocodingService
    extends IntentService {
        private Geocoder geocoder;

        public AndroidGeocodingService() {
            super(AndroidGeocodingService.class.getSimpleName());
        }

        protected void onHandleIntent(Intent intent) {
            ArrayList<LocationAddress> response;
            int maxResults;
            Locale locale = (Locale)intent.getSerializableExtra(AndroidGeocodingProvider.LOCALE_ID);
            this.geocoder = locale == null ? new Geocoder((Context)this) : new Geocoder((Context)this, locale);
            if (intent.hasExtra(AndroidGeocodingProvider.DIRECT_GEOCODING_ID)) {
                HashMap nameList = (HashMap)intent.getSerializableExtra(AndroidGeocodingProvider.DIRECT_GEOCODING_ID);
                for (String name : nameList.keySet()) {
                    maxResults = (Integer)nameList.get(name);
                    response = this.addressFromName(name, maxResults);
                    this.sendDirectGeocodingBroadcast(name, response);
                }
            }
            if (intent.hasExtra(AndroidGeocodingProvider.REVERSE_GEOCODING_ID)) {
                HashMap locationList = (HashMap)intent.getSerializableExtra(AndroidGeocodingProvider.REVERSE_GEOCODING_ID);
                for (Location location : locationList.keySet()) {
                    maxResults = (Integer)locationList.get(location);
                    response = this.addressFromLocation(location, maxResults);
                    this.sendReverseGeocodingBroadcast(location, response);
                }
            }
        }

        private void sendDirectGeocodingBroadcast(String name, ArrayList<LocationAddress> results) {
            Intent directIntent = new Intent(BROADCAST_DIRECT_GEOCODING_ACTION);
            directIntent.putExtra(AndroidGeocodingProvider.NAME_ID, name);
            directIntent.putExtra(AndroidGeocodingProvider.RESULT_ID, results);
            this.sendBroadcast(directIntent);
        }

        private void sendReverseGeocodingBroadcast(Location location, ArrayList<Address> results) {
            Intent reverseIntent = new Intent(BROADCAST_REVERSE_GEOCODING_ACTION);
            reverseIntent.putExtra(AndroidGeocodingProvider.LOCATION_ID, (Parcelable)location);
            reverseIntent.putExtra(AndroidGeocodingProvider.RESULT_ID, results);
            this.sendBroadcast(reverseIntent);
        }

        private ArrayList<Address> addressFromLocation(Location location, int maxResults) {
            try {
                return new ArrayList<Address>(this.geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), maxResults));
            }
            catch (IOException iOException) {
                return new ArrayList<Address>();
            }
        }

        private ArrayList<LocationAddress> addressFromName(String name, int maxResults) {
            try {
                List addresses = this.geocoder.getFromLocationName(name, maxResults);
                ArrayList<LocationAddress> result = new ArrayList<LocationAddress>();
                for (Address address : addresses) {
                    result.add(new LocationAddress(address));
                }
                return result;
            }
            catch (IOException iOException) {
                return new ArrayList<LocationAddress>();
            }
        }
    }
}

