/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.activity.providers;

import android.app.Activity;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.ActivityRecognition;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;
import io.nlopez.smartlocation.OnActivityUpdatedListener;
import io.nlopez.smartlocation.activity.ActivityProvider;
import io.nlopez.smartlocation.activity.ActivityStore;
import io.nlopez.smartlocation.activity.config.ActivityParams;
import io.nlopez.smartlocation.utils.GooglePlayServicesListener;
import io.nlopez.smartlocation.utils.Logger;

public class ActivityGooglePlayServicesProvider
implements ActivityProvider,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
ResultCallback<Status> {
    public static final int RESULT_CODE = 10002;
    private static final String GMS_ID = "GMS";
    private static final String BROADCAST_INTENT_ACTION = ActivityGooglePlayServicesProvider.class.getCanonicalName() + ".DETECTED_ACTIVITY";
    private static final String DETECTED_ACTIVITY_EXTRA_ID = "activity";
    private GoogleApiClient client;
    private Logger logger;
    private OnActivityUpdatedListener listener;
    private ActivityStore activityStore;
    private Context context;
    private boolean shouldStart = false;
    private boolean stopped = false;
    private PendingIntent pendingIntent;
    private ActivityParams activityParams;
    private final GooglePlayServicesListener googlePlayServicesListener;
    private BroadcastReceiver activityReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (BROADCAST_INTENT_ACTION.equals(intent.getAction()) && intent.hasExtra(ActivityGooglePlayServicesProvider.DETECTED_ACTIVITY_EXTRA_ID)) {
                ActivityGooglePlayServicesProvider.this.logger.d("sending new activity", new Object[0]);
                DetectedActivity detectedActivity = (DetectedActivity)intent.getParcelableExtra(ActivityGooglePlayServicesProvider.DETECTED_ACTIVITY_EXTRA_ID);
                ActivityGooglePlayServicesProvider.this.notifyActivity(detectedActivity);
            }
        }
    };

    public ActivityGooglePlayServicesProvider() {
        this(null);
    }

    public ActivityGooglePlayServicesProvider(GooglePlayServicesListener playServicesListener) {
        this.googlePlayServicesListener = playServicesListener;
    }

    @Override
    public void init(@NonNull Context context, Logger logger) {
        this.context = context;
        this.logger = logger;
        this.activityStore = new ActivityStore(context);
        if (!this.shouldStart) {
            this.client = new GoogleApiClient.Builder(context).addApi(ActivityRecognition.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
            this.client.connect();
        } else {
            logger.d("already started", new Object[0]);
        }
    }

    @Override
    public void start(OnActivityUpdatedListener listener, @NonNull ActivityParams params) {
        this.activityParams = params;
        this.listener = listener;
        IntentFilter intentFilter = new IntentFilter(BROADCAST_INTENT_ACTION);
        this.context.registerReceiver(this.activityReceiver, intentFilter);
        if (this.client.isConnected()) {
            this.startUpdating(params);
        } else if (this.stopped) {
            this.shouldStart = true;
            this.client.connect();
            this.stopped = false;
        } else {
            this.shouldStart = true;
            this.logger.d("still not connected - scheduled start when connection is ok", new Object[0]);
        }
    }

    private void startUpdating(ActivityParams params) {
        if (this.client.isConnected()) {
            this.pendingIntent = PendingIntent.getService((Context)this.context, (int)0, (Intent)new Intent(this.context, ActivityRecognitionService.class), (int)0x8000000);
            ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates(this.client, params.getInterval(), this.pendingIntent).setResultCallback((ResultCallback)this);
        }
    }

    @Override
    public void stop() {
        this.logger.d("stop", new Object[0]);
        if (this.client.isConnected()) {
            ActivityRecognition.ActivityRecognitionApi.removeActivityUpdates(this.client, this.pendingIntent);
            this.client.disconnect();
        }
        try {
            this.context.unregisterReceiver(this.activityReceiver);
        }
        catch (IllegalArgumentException e) {
            this.logger.d("Silenced 'receiver not registered' stuff (calling stop more times than necessary did this)", new Object[0]);
        }
        this.shouldStart = false;
        this.stopped = true;
    }

    @Override
    public DetectedActivity getLastActivity() {
        if (this.activityStore != null) {
            return this.activityStore.get(GMS_ID);
        }
        return null;
    }

    public void onConnected(Bundle bundle) {
        this.logger.d("onConnected", new Object[0]);
        if (this.shouldStart) {
            this.startUpdating(this.activityParams);
        }
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnected(bundle);
        }
    }

    public void onConnectionSuspended(int i) {
        this.logger.d("onConnectionSuspended " + i, new Object[0]);
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnectionSuspended(i);
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.logger.d("onConnectionFailed", new Object[0]);
        if (this.googlePlayServicesListener != null) {
            this.googlePlayServicesListener.onConnectionFailed(connectionResult);
        }
    }

    private void notifyActivity(DetectedActivity detectedActivity) {
        if (this.listener != null) {
            this.listener.onActivityUpdated(detectedActivity);
        }
        if (this.activityStore != null) {
            this.activityStore.put(GMS_ID, detectedActivity);
        }
    }

    public void onResult(@NonNull Status status) {
        if (status.isSuccess()) {
            this.logger.d("Activity update request successful", new Object[0]);
        } else if (status.hasResolution() && this.context instanceof Activity) {
            this.logger.w("Unable to register, but we can solve this - will startActivityForResult expecting result code 10002 (if received, please try again)", new Object[0]);
            try {
                status.startResolutionForResult((Activity)this.context, 10002);
            }
            catch (IntentSender.SendIntentException e) {
                this.logger.e(e, "problem with startResolutionForResult", new Object[0]);
            }
        } else {
            this.logger.e("Registering failed: " + status.getStatusMessage(), new Object[0]);
        }
    }

    public static class ActivityRecognitionService
    extends IntentService {
        public ActivityRecognitionService() {
            super(ActivityRecognitionService.class.getSimpleName());
        }

        protected void onHandleIntent(Intent intent) {
            if (ActivityRecognitionResult.hasResult((Intent)intent)) {
                ActivityRecognitionResult result = ActivityRecognitionResult.extractResult((Intent)intent);
                DetectedActivity mostProbableActivity = result.getMostProbableActivity();
                Intent activityIntent = new Intent(BROADCAST_INTENT_ACTION);
                activityIntent.putExtra(ActivityGooglePlayServicesProvider.DETECTED_ACTIVITY_EXTRA_ID, (Parcelable)mostProbableActivity);
                this.sendBroadcast(activityIntent);
            }
        }
    }
}

