/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.rx;

import android.content.Context;
import android.location.Address;
import android.location.Location;
import com.google.android.gms.location.DetectedActivity;
import io.nlopez.smartlocation.OnActivityUpdatedListener;
import io.nlopez.smartlocation.OnGeocodingListener;
import io.nlopez.smartlocation.OnGeofencingTransitionListener;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.OnReverseGeocodingListener;
import io.nlopez.smartlocation.SmartLocation;
import io.nlopez.smartlocation.geocoding.utils.LocationAddress;
import io.nlopez.smartlocation.geofencing.utils.TransitionGeofence;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;

public class ObservableFactory {
    private ObservableFactory() {
        throw new AssertionError((Object)"This should not be instantiated");
    }

    public static Observable<Location> from(final SmartLocation.LocationControl locationControl) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Location>(){

            public void call(final Subscriber<? super Location> subscriber) {
                locationControl.start(new OnLocationUpdatedListener(){

                    @Override
                    public void onLocationUpdated(Location location) {
                        subscriber.onNext((Object)location);
                    }
                });
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                locationControl.stop();
            }
        });
        return result;
    }

    public static Observable<DetectedActivity> from(final SmartLocation.ActivityRecognitionControl activityControl) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<DetectedActivity>(){

            public void call(final Subscriber<? super DetectedActivity> subscriber) {
                activityControl.start(new OnActivityUpdatedListener(){

                    @Override
                    public void onActivityUpdated(DetectedActivity detectedActivity) {
                        subscriber.onNext((Object)detectedActivity);
                    }
                });
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                activityControl.stop();
            }
        });
        return result;
    }

    public static Observable<TransitionGeofence> from(final SmartLocation.GeofencingControl geofencingControl) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<TransitionGeofence>(){

            public void call(final Subscriber<? super TransitionGeofence> subscriber) {
                geofencingControl.start(new OnGeofencingTransitionListener(){

                    @Override
                    public void onGeofenceTransition(TransitionGeofence transitionGeofence) {
                        subscriber.onNext((Object)transitionGeofence);
                    }
                });
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                geofencingControl.stop();
            }
        });
        return result;
    }

    public static Observable<List<LocationAddress>> fromAddress(final Context context, final String address, final int maxResults) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<LocationAddress>>(){

            public void call(final Subscriber<? super List<LocationAddress>> subscriber) {
                SmartLocation.with(context).geocoding().add(address, maxResults).start(new OnGeocodingListener(){

                    @Override
                    public void onLocationResolved(String name, List<LocationAddress> results) {
                        subscriber.onNext(results);
                        subscriber.onCompleted();
                    }
                });
            }
        });
        return result;
    }

    public static Observable<List<Address>> fromLocation(final Context context, final Location location, final int maxResults) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<Address>>(){

            public void call(final Subscriber<? super List<Address>> subscriber) {
                SmartLocation.with(context).geocoding().add(location, maxResults).start(new OnReverseGeocodingListener(){

                    @Override
                    public void onAddressResolved(Location original, List<Address> results) {
                        subscriber.onNext(results);
                        subscriber.onCompleted();
                    }
                });
            }
        });
        return result;
    }
}

