/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;

public class LocationState {
    @SuppressLint(value={"StaticFieldLeak"})
    private static LocationState instance;
    private Context context;
    private LocationManager locationManager;

    private LocationState(Context context) {
        this.context = context;
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    public static LocationState with(Context context) {
        if (instance == null) {
            instance = new LocationState(context.getApplicationContext());
        }
        return instance;
    }

    public boolean locationServicesEnabled() {
        if (Build.VERSION.SDK_INT >= 19) {
            int locationMode = 0;
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
            return locationMode != 0;
        }
        String locationProviders = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"location_providers_allowed");
        return !TextUtils.isEmpty((CharSequence)locationProviders);
    }

    public boolean isAnyProviderAvailable() {
        return this.isGpsAvailable() || this.isNetworkAvailable();
    }

    public boolean isGpsAvailable() {
        return this.locationManager.isProviderEnabled("gps");
    }

    public boolean isNetworkAvailable() {
        return this.locationManager.isProviderEnabled("network");
    }

    public boolean isPassiveAvailable() {
        return this.locationManager.isProviderEnabled("passive");
    }

    @Deprecated
    public boolean isMockSettingEnabled() {
        return !"0".equals(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"mock_location"));
    }
}

