/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.providers;

import android.content.Context;
import android.location.Location;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.location.LocationProvider;
import io.nlopez.smartlocation.location.ServiceLocationProvider;
import io.nlopez.smartlocation.location.config.LocationParams;
import io.nlopez.smartlocation.location.providers.FallbackListenerWrapper;
import io.nlopez.smartlocation.location.providers.LocationGooglePlayServicesProvider;
import io.nlopez.smartlocation.location.providers.LocationManagerProvider;
import io.nlopez.smartlocation.utils.Logger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;

public class MultiFallbackProvider
implements LocationProvider {
    private Queue<LocationProvider> providers = new LinkedList<LocationProvider>();
    private LocationProvider currentProvider;
    private Context context;
    private Logger logger;
    private OnLocationUpdatedListener locationListener;
    private LocationParams locationParams;
    private boolean singleUpdate;
    private boolean shouldStart;

    MultiFallbackProvider() {
    }

    @Override
    public void init(Context context, Logger logger) {
        this.context = context;
        this.logger = logger;
        LocationProvider current = this.getCurrentProvider();
        if (current != null) {
            current.init(context, logger);
        }
    }

    @Override
    public void start(OnLocationUpdatedListener listener, LocationParams params, boolean singleUpdate) {
        this.shouldStart = true;
        this.locationListener = listener;
        this.locationParams = params;
        this.singleUpdate = singleUpdate;
        LocationProvider current = this.getCurrentProvider();
        if (current != null) {
            current.start(listener, params, singleUpdate);
        }
    }

    @Override
    public void stop() {
        LocationProvider current = this.getCurrentProvider();
        if (current != null) {
            current.stop();
        }
    }

    @Override
    public Location getLastLocation() {
        LocationProvider current = this.getCurrentProvider();
        if (current == null) {
            return null;
        }
        return current.getLastLocation();
    }

    boolean addProvider(LocationProvider provider) {
        return this.providers.add(provider);
    }

    Collection<LocationProvider> getProviders() {
        return this.providers;
    }

    LocationProvider getCurrentProvider() {
        if (this.currentProvider == null && !this.providers.isEmpty()) {
            this.currentProvider = this.providers.poll();
        }
        return this.currentProvider;
    }

    void fallbackProvider() {
        if (!this.providers.isEmpty()) {
            this.currentProvider.stop();
            this.currentProvider = this.providers.poll();
            this.currentProvider.init(this.context, this.logger);
            if (this.shouldStart) {
                this.currentProvider.start(this.locationListener, this.locationParams, this.singleUpdate);
            }
        }
    }

    public static class Builder {
        private MultiFallbackProvider builtProvider = new MultiFallbackProvider();

        public Builder withGooglePlayServicesProvider() {
            return this.withServiceProvider(new LocationGooglePlayServicesProvider());
        }

        public Builder withDefaultProvider() {
            return this.withProvider(new LocationManagerProvider());
        }

        public Builder withServiceProvider(ServiceLocationProvider provider) {
            FallbackListenerWrapper fallbackListener = new FallbackListenerWrapper(this.builtProvider, provider);
            provider.setServiceListener(fallbackListener);
            return this.withProvider(provider);
        }

        public Builder withProvider(LocationProvider provider) {
            this.builtProvider.addProvider(provider);
            return this;
        }

        public MultiFallbackProvider build() {
            if (this.builtProvider.providers.isEmpty()) {
                this.withDefaultProvider();
            }
            return this.builtProvider;
        }
    }
}

