/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.providers;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.location.LocationProvider;
import io.nlopez.smartlocation.location.config.LocationParams;
import io.nlopez.smartlocation.location.providers.LocationGooglePlayServicesProvider;
import io.nlopez.smartlocation.location.providers.LocationManagerProvider;
import io.nlopez.smartlocation.utils.GooglePlayServicesListener;
import io.nlopez.smartlocation.utils.Logger;

public class LocationGooglePlayServicesWithFallbackProvider
implements LocationProvider,
GooglePlayServicesListener {
    private Logger logger;
    private OnLocationUpdatedListener listener;
    private boolean shouldStart = false;
    private Context context;
    private LocationParams params;
    private boolean singleUpdate = false;
    private LocationProvider provider;

    public LocationGooglePlayServicesWithFallbackProvider(Context context) {
        this.provider = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context) == 0 ? new LocationGooglePlayServicesProvider(this) : new LocationManagerProvider();
    }

    @Override
    public void init(Context context, Logger logger) {
        this.logger = logger;
        this.context = context;
        logger.d("Currently selected provider = " + this.provider.getClass().getSimpleName(), new Object[0]);
        this.provider.init(context, logger);
    }

    @Override
    public void start(OnLocationUpdatedListener listener, LocationParams params, boolean singleUpdate) {
        this.shouldStart = true;
        this.listener = listener;
        this.params = params;
        this.singleUpdate = singleUpdate;
        this.provider.start(listener, params, singleUpdate);
    }

    @Override
    public void stop() {
        this.provider.stop();
        this.shouldStart = false;
    }

    @Override
    public Location getLastLocation() {
        return this.provider.getLastLocation();
    }

    @Override
    public void onConnected(Bundle bundle) {
    }

    @Override
    public void onConnectionSuspended(int i) {
        this.fallbackToLocationManager();
    }

    @Override
    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.fallbackToLocationManager();
    }

    private void fallbackToLocationManager() {
        this.logger.d("FusedLocationProvider not working, falling back and using LocationManager", new Object[0]);
        this.provider = new LocationManagerProvider();
        this.provider.init(this.context, this.logger);
        if (this.shouldStart) {
            this.provider.start(this.listener, this.params, this.singleUpdate);
        }
    }
}

