/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.providers;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import com.google.android.gms.location.DetectedActivity;
import io.nlopez.smartlocation.OnActivityUpdatedListener;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.activity.config.ActivityParams;
import io.nlopez.smartlocation.activity.providers.ActivityGooglePlayServicesProvider;
import io.nlopez.smartlocation.location.LocationProvider;
import io.nlopez.smartlocation.location.config.LocationParams;
import io.nlopez.smartlocation.location.providers.LocationGooglePlayServicesProvider;
import io.nlopez.smartlocation.utils.Logger;

public class LocationBasedOnActivityProvider
implements LocationProvider,
OnActivityUpdatedListener {
    private final ActivityGooglePlayServicesProvider activityProvider = new ActivityGooglePlayServicesProvider();
    private final LocationGooglePlayServicesProvider locationProvider = new LocationGooglePlayServicesProvider();
    private final LocationBasedOnActivityListener locationBasedOnActivityListener;
    private OnLocationUpdatedListener locationUpdatedListener;
    private LocationParams locationParams;

    public LocationBasedOnActivityProvider(@NonNull LocationBasedOnActivityListener locationBasedOnActivityListener) {
        this.locationBasedOnActivityListener = locationBasedOnActivityListener;
    }

    @Override
    public void init(Context context, Logger logger) {
        this.locationProvider.init(context, logger);
        this.activityProvider.init(context, logger);
    }

    @Override
    public void start(OnLocationUpdatedListener listener, LocationParams params, boolean singleUpdate) {
        if (singleUpdate) {
            throw new IllegalArgumentException("singleUpdate cannot be set to true");
        }
        this.locationProvider.start(listener, params, false);
        this.activityProvider.start(this, ActivityParams.NORMAL);
        this.locationParams = params;
        this.locationUpdatedListener = listener;
    }

    @Override
    public void stop() {
        this.locationProvider.stop();
        this.activityProvider.stop();
    }

    @Override
    public Location getLastLocation() {
        return this.locationProvider.getLastLocation();
    }

    @Override
    public void onActivityUpdated(DetectedActivity detectedActivity) {
        LocationParams params = this.locationBasedOnActivityListener.locationParamsForActivity(detectedActivity);
        if (params != null && this.locationParams != null && !this.locationParams.equals(params)) {
            this.start(this.locationUpdatedListener, params, false);
        }
    }

    public static interface LocationBasedOnActivityListener {
        public LocationParams locationParamsForActivity(DetectedActivity var1);
    }
}

