/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location.providers;

import android.support.annotation.NonNull;
import io.nlopez.smartlocation.location.LocationProvider;
import io.nlopez.smartlocation.location.ServiceLocationProvider;
import io.nlopez.smartlocation.location.providers.MultiFallbackProvider;
import io.nlopez.smartlocation.utils.ServiceConnectionListener;

class FallbackListenerWrapper
implements ServiceConnectionListener {
    private final ServiceConnectionListener listener;
    private final MultiFallbackProvider fallbackProvider;
    private final ServiceLocationProvider childProvider;

    public FallbackListenerWrapper(@NonNull MultiFallbackProvider parentProvider, ServiceLocationProvider childProvider) {
        this.fallbackProvider = parentProvider;
        this.childProvider = childProvider;
        this.listener = childProvider.getServiceListener();
    }

    @Override
    public void onConnected() {
        if (this.listener != null) {
            this.listener.onConnected();
        }
    }

    @Override
    public void onConnectionSuspended() {
        if (this.listener != null) {
            this.listener.onConnectionSuspended();
        }
        this.runFallback();
    }

    @Override
    public void onConnectionFailed() {
        if (this.listener != null) {
            this.listener.onConnectionFailed();
        }
        this.runFallback();
    }

    private void runFallback() {
        LocationProvider current = this.fallbackProvider.getCurrentProvider();
        if (current != null && current.equals(this.childProvider)) {
            this.fallbackProvider.fallbackProvider();
        }
    }
}

