/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.location;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.nlopez.smartlocation.common.Store;

public class LocationStore
implements Store<Location> {
    public static final String PROVIDER = "LocationStore";
    private static final String PREFERENCES_FILE = "LOCATION_STORE";
    private static final String PREFIX_ID = LocationStore.class.getCanonicalName() + ".KEY";
    private static final String PROVIDER_ID = "PROVIDER";
    private static final String LATITUDE_ID = "LATITUDE";
    private static final String LONGITUDE_ID = "LONGITUDE";
    private static final String ACCURACY_ID = "ACCURACY";
    private static final String ALTITUDE_ID = "ALTITUDE";
    private static final String SPEED_ID = "SPEED";
    private static final String TIME_ID = "TIME";
    private static final String BEARING_ID = "BEARING";
    private SharedPreferences preferences;

    public LocationStore(@NonNull Context context) {
        this.preferences = context.getSharedPreferences(PREFERENCES_FILE, 0);
    }

    @VisibleForTesting
    public void setPreferences(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void put(String id, Location location) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(this.getFieldKey(id, PROVIDER_ID), location.getProvider());
        editor.putLong(this.getFieldKey(id, LATITUDE_ID), Double.doubleToLongBits(location.getLatitude()));
        editor.putLong(this.getFieldKey(id, LONGITUDE_ID), Double.doubleToLongBits(location.getLongitude()));
        editor.putFloat(this.getFieldKey(id, ACCURACY_ID), location.getAccuracy());
        editor.putLong(this.getFieldKey(id, ALTITUDE_ID), Double.doubleToLongBits(location.getAltitude()));
        editor.putFloat(this.getFieldKey(id, SPEED_ID), location.getSpeed());
        editor.putLong(this.getFieldKey(id, TIME_ID), location.getTime());
        editor.putFloat(this.getFieldKey(id, BEARING_ID), location.getBearing());
        editor.apply();
    }

    @Override
    public Location get(String id) {
        if (this.preferences != null && this.preferences.contains(this.getFieldKey(id, LATITUDE_ID)) && this.preferences.contains(this.getFieldKey(id, LONGITUDE_ID))) {
            Location location = new Location(this.preferences.getString(PROVIDER_ID, PROVIDER));
            location.setLatitude(Double.longBitsToDouble(this.preferences.getLong(this.getFieldKey(id, LATITUDE_ID), 0L)));
            location.setLongitude(Double.longBitsToDouble(this.preferences.getLong(this.getFieldKey(id, LONGITUDE_ID), 0L)));
            location.setAccuracy(this.preferences.getFloat(this.getFieldKey(id, ACCURACY_ID), 0.0f));
            location.setAltitude(Double.longBitsToDouble(this.preferences.getLong(this.getFieldKey(id, ALTITUDE_ID), 0L)));
            location.setSpeed(this.preferences.getFloat(this.getFieldKey(id, SPEED_ID), 0.0f));
            location.setTime(this.preferences.getLong(this.getFieldKey(id, TIME_ID), 0L));
            location.setBearing(this.preferences.getFloat(this.getFieldKey(id, BEARING_ID), 0.0f));
            return location;
        }
        return null;
    }

    @Override
    public void remove(String id) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(this.getFieldKey(id, PROVIDER_ID));
        editor.remove(this.getFieldKey(id, LATITUDE_ID));
        editor.remove(this.getFieldKey(id, LONGITUDE_ID));
        editor.remove(this.getFieldKey(id, ACCURACY_ID));
        editor.remove(this.getFieldKey(id, ALTITUDE_ID));
        editor.remove(this.getFieldKey(id, SPEED_ID));
        editor.remove(this.getFieldKey(id, TIME_ID));
        editor.remove(this.getFieldKey(id, BEARING_ID));
        editor.apply();
    }

    private String getFieldKey(String id, String field) {
        return PREFIX_ID + "_" + id + "_" + field;
    }
}

