/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.geofencing;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.nlopez.smartlocation.common.Store;
import io.nlopez.smartlocation.geofencing.model.GeofenceModel;

public class GeofencingStore
implements Store<GeofenceModel> {
    private static final String PREFERENCES_FILE = "GEOFENCING_STORE";
    private static final String PREFIX_ID = GeofencingStore.class.getCanonicalName() + ".KEY";
    private static final String LATITUDE_ID = "LATITUDE";
    private static final String LONGITUDE_ID = "LONGITUDE";
    private static final String RADIUS_ID = "RADIUS";
    private static final String TRANSITION_ID = "TRANSITION";
    private static final String EXPIRATION_ID = "EXPIRATION";
    private static final String LOITERING_DELAY_ID = "LOITERING_DELAY";
    private SharedPreferences preferences;

    public GeofencingStore(@NonNull Context context) {
        this.preferences = context.getSharedPreferences(PREFERENCES_FILE, 0);
    }

    @VisibleForTesting
    public void setPreferences(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void put(String id, GeofenceModel geofenceModel) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(this.getFieldKey(id, LATITUDE_ID), Double.doubleToLongBits(geofenceModel.getLatitude()));
        editor.putLong(this.getFieldKey(id, LONGITUDE_ID), Double.doubleToLongBits(geofenceModel.getLongitude()));
        editor.putFloat(this.getFieldKey(id, RADIUS_ID), geofenceModel.getRadius());
        editor.putInt(this.getFieldKey(id, TRANSITION_ID), geofenceModel.getTransition());
        editor.putLong(this.getFieldKey(id, EXPIRATION_ID), geofenceModel.getExpiration());
        editor.putInt(this.getFieldKey(id, LOITERING_DELAY_ID), geofenceModel.getLoiteringDelay());
        editor.apply();
    }

    @Override
    public GeofenceModel get(String id) {
        if (this.preferences != null && this.preferences.contains(this.getFieldKey(id, LATITUDE_ID)) && this.preferences.contains(this.getFieldKey(id, LONGITUDE_ID))) {
            GeofenceModel.Builder builder = new GeofenceModel.Builder(id);
            builder.setLatitude(Double.longBitsToDouble(this.preferences.getLong(this.getFieldKey(id, LATITUDE_ID), 0L)));
            builder.setLongitude(Double.longBitsToDouble(this.preferences.getLong(this.getFieldKey(id, LONGITUDE_ID), 0L)));
            builder.setRadius(this.preferences.getFloat(this.getFieldKey(id, RADIUS_ID), 0.0f));
            builder.setTransition(this.preferences.getInt(this.getFieldKey(id, TRANSITION_ID), 0));
            builder.setExpiration(this.preferences.getLong(this.getFieldKey(id, EXPIRATION_ID), 0L));
            builder.setLoiteringDelay(this.preferences.getInt(this.getFieldKey(id, LOITERING_DELAY_ID), 0));
            return builder.build();
        }
        return null;
    }

    @Override
    public void remove(String id) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(this.getFieldKey(id, LATITUDE_ID));
        editor.remove(this.getFieldKey(id, LONGITUDE_ID));
        editor.remove(this.getFieldKey(id, RADIUS_ID));
        editor.remove(this.getFieldKey(id, TRANSITION_ID));
        editor.remove(this.getFieldKey(id, EXPIRATION_ID));
        editor.remove(this.getFieldKey(id, LOITERING_DELAY_ID));
        editor.apply();
    }

    private String getFieldKey(String id, String field) {
        return PREFIX_ID + "_" + id + "_" + field;
    }
}

