/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation.activity;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.location.DetectedActivity;
import io.nlopez.smartlocation.common.Store;

public class ActivityStore
implements Store<DetectedActivity> {
    private static final String PREFERENCES_FILE = "ACTIVITY_STORE";
    private static final String PREFIX_ID = ActivityStore.class.getCanonicalName() + ".KEY";
    private static final String ACTIVITY_ID = "ACTIVITY";
    private static final String CONFIDENCE_ID = "CONFIDENCE";
    private static final String VERSION_CODE_ID = "VERSION_CODE";
    private SharedPreferences preferences;

    public ActivityStore(@NonNull Context context) {
        this.preferences = context.getSharedPreferences(PREFERENCES_FILE, 0);
    }

    @VisibleForTesting
    public void setPreferences(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void put(String id, DetectedActivity activity) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putInt(this.getFieldKey(id, ACTIVITY_ID), activity.getType());
        editor.putInt(this.getFieldKey(id, CONFIDENCE_ID), activity.getConfidence());
        editor.putInt(this.getFieldKey(id, VERSION_CODE_ID), activity.getVersionCode());
        editor.apply();
    }

    @Override
    public DetectedActivity get(String id) {
        if (this.preferences != null && this.preferences.contains(this.getFieldKey(id, ACTIVITY_ID)) && this.preferences.contains(this.getFieldKey(id, CONFIDENCE_ID))) {
            int activity = this.preferences.getInt(this.getFieldKey(id, ACTIVITY_ID), 4);
            int confidence = this.preferences.getInt(this.getFieldKey(id, CONFIDENCE_ID), 0);
            int versionCode = this.preferences.getInt(this.getFieldKey(id, VERSION_CODE_ID), 0);
            return new DetectedActivity(versionCode, activity, confidence);
        }
        return null;
    }

    @Override
    public void remove(String id) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(this.getFieldKey(id, ACTIVITY_ID));
        editor.remove(this.getFieldKey(id, CONFIDENCE_ID));
        editor.remove(this.getFieldKey(id, VERSION_CODE_ID));
        editor.apply();
    }

    private String getFieldKey(String id, String field) {
        return PREFIX_ID + "_" + id + "_" + field;
    }
}

