/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.smartlocation;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.location.DetectedActivity;
import io.nlopez.smartlocation.OnActivityUpdatedListener;
import io.nlopez.smartlocation.OnGeocodingListener;
import io.nlopez.smartlocation.OnGeofencingTransitionListener;
import io.nlopez.smartlocation.OnLocationUpdatedListener;
import io.nlopez.smartlocation.OnReverseGeocodingListener;
import io.nlopez.smartlocation.activity.ActivityProvider;
import io.nlopez.smartlocation.activity.config.ActivityParams;
import io.nlopez.smartlocation.activity.providers.ActivityGooglePlayServicesProvider;
import io.nlopez.smartlocation.geocoding.GeocodingProvider;
import io.nlopez.smartlocation.geocoding.providers.AndroidGeocodingProvider;
import io.nlopez.smartlocation.geofencing.GeofencingProvider;
import io.nlopez.smartlocation.geofencing.model.GeofenceModel;
import io.nlopez.smartlocation.geofencing.providers.GeofencingGooglePlayServicesProvider;
import io.nlopez.smartlocation.location.LocationProvider;
import io.nlopez.smartlocation.location.config.LocationParams;
import io.nlopez.smartlocation.location.providers.LocationGooglePlayServicesWithFallbackProvider;
import io.nlopez.smartlocation.location.utils.LocationState;
import io.nlopez.smartlocation.utils.Logger;
import io.nlopez.smartlocation.utils.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class SmartLocation {
    private Context context;
    private Logger logger;
    private boolean preInitialize;

    private SmartLocation(Context context, Logger logger, boolean preInitialize) {
        this.context = context;
        this.logger = logger;
        this.preInitialize = preInitialize;
    }

    public static SmartLocation with(Context context) {
        return new Builder(context).build();
    }

    public LocationControl location() {
        return this.location(new LocationGooglePlayServicesWithFallbackProvider(this.context));
    }

    public LocationControl location(LocationProvider provider) {
        return new LocationControl(this, provider);
    }

    @Deprecated
    public ActivityRecognitionControl activityRecognition() {
        return this.activity();
    }

    public ActivityRecognitionControl activity() {
        return this.activity(new ActivityGooglePlayServicesProvider());
    }

    public ActivityRecognitionControl activity(ActivityProvider activityProvider) {
        return new ActivityRecognitionControl(this, activityProvider);
    }

    public GeofencingControl geofencing() {
        return this.geofencing(new GeofencingGooglePlayServicesProvider());
    }

    public GeofencingControl geofencing(GeofencingProvider geofencingProvider) {
        return new GeofencingControl(this, geofencingProvider);
    }

    public GeocodingControl geocoding() {
        return this.geocoding(new AndroidGeocodingProvider());
    }

    public GeocodingControl geocoding(GeocodingProvider geocodingProvider) {
        return new GeocodingControl(this, geocodingProvider);
    }

    public static class GeofencingControl {
        private static final Map<Context, GeofencingProvider> MAPPING = new WeakHashMap<Context, GeofencingProvider>();
        private final SmartLocation smartLocation;
        private GeofencingProvider provider;

        public GeofencingControl(@NonNull SmartLocation smartLocation, @NonNull GeofencingProvider geofencingProvider) {
            this.smartLocation = smartLocation;
            if (!MAPPING.containsKey(smartLocation.context)) {
                MAPPING.put(smartLocation.context, geofencingProvider);
            }
            this.provider = MAPPING.get(smartLocation.context);
            if (smartLocation.preInitialize) {
                this.provider.init(smartLocation.context, smartLocation.logger);
            }
        }

        public GeofencingControl add(@NonNull GeofenceModel geofenceModel) {
            this.provider.addGeofence(geofenceModel);
            return this;
        }

        public GeofencingControl remove(@NonNull String geofenceId) {
            this.provider.removeGeofence(geofenceId);
            return this;
        }

        public GeofencingControl addAll(@NonNull List<GeofenceModel> geofenceModelList) {
            this.provider.addGeofences(geofenceModelList);
            return this;
        }

        public GeofencingControl removeAll(@NonNull List<String> geofenceIdsList) {
            this.provider.removeGeofences(geofenceIdsList);
            return this;
        }

        public void start(OnGeofencingTransitionListener listener) {
            if (this.provider == null) {
                throw new RuntimeException("A provider must be initialized");
            }
            this.provider.start(listener);
        }

        public void stop() {
            this.provider.stop();
        }
    }

    public static class ActivityRecognitionControl {
        private static final Map<Context, ActivityProvider> MAPPING = new WeakHashMap<Context, ActivityProvider>();
        private final SmartLocation smartLocation;
        private ActivityParams params;
        private ActivityProvider provider;

        public ActivityRecognitionControl(@NonNull SmartLocation smartLocation, @NonNull ActivityProvider activityProvider) {
            this.smartLocation = smartLocation;
            this.params = ActivityParams.NORMAL;
            if (!MAPPING.containsKey(smartLocation.context)) {
                MAPPING.put(smartLocation.context, activityProvider);
            }
            this.provider = MAPPING.get(smartLocation.context);
            if (smartLocation.preInitialize) {
                this.provider.init(smartLocation.context, smartLocation.logger);
            }
        }

        public ActivityRecognitionControl config(@NonNull ActivityParams params) {
            this.params = params;
            return this;
        }

        @Nullable
        public DetectedActivity getLastActivity() {
            return this.provider.getLastActivity();
        }

        public ActivityRecognitionControl get() {
            return this;
        }

        public void start(OnActivityUpdatedListener listener) {
            if (this.provider == null) {
                throw new RuntimeException("A provider must be initialized");
            }
            this.provider.start(listener, this.params);
        }

        public void stop() {
            this.provider.stop();
        }
    }

    public static class GeocodingControl {
        private static final Map<Context, GeocodingProvider> MAPPING = new WeakHashMap<Context, GeocodingProvider>();
        private final SmartLocation smartLocation;
        private GeocodingProvider provider;
        private boolean directAdded = false;
        private boolean reverseAdded = false;

        public GeocodingControl(@NonNull SmartLocation smartLocation, @NonNull GeocodingProvider geocodingProvider) {
            this.smartLocation = smartLocation;
            if (!MAPPING.containsKey(smartLocation.context)) {
                MAPPING.put(smartLocation.context, geocodingProvider);
            }
            this.provider = MAPPING.get(smartLocation.context);
            if (smartLocation.preInitialize) {
                this.provider.init(smartLocation.context, smartLocation.logger);
            }
        }

        public GeocodingControl get() {
            return this;
        }

        public void reverse(@NonNull Location location, @NonNull OnReverseGeocodingListener reverseGeocodingListener) {
            this.add(location);
            this.start(reverseGeocodingListener);
        }

        public void direct(@NonNull String name, @NonNull OnGeocodingListener geocodingListener) {
            this.add(name);
            this.start(geocodingListener);
        }

        public GeocodingControl add(@NonNull Location location) {
            this.reverseAdded = true;
            this.provider.addLocation(location, 1);
            return this;
        }

        public GeocodingControl add(@NonNull Location location, int maxResults) {
            this.reverseAdded = true;
            this.provider.addLocation(location, maxResults);
            return this;
        }

        public GeocodingControl add(@NonNull String name) {
            this.directAdded = true;
            this.provider.addName(name, 1);
            return this;
        }

        public GeocodingControl add(@NonNull String name, int maxResults) {
            this.directAdded = true;
            this.provider.addName(name, maxResults);
            return this;
        }

        public void start(OnGeocodingListener geocodingListener) {
            this.start(geocodingListener, null);
        }

        public void start(OnReverseGeocodingListener reverseGeocodingListener) {
            this.start(null, reverseGeocodingListener);
        }

        public void start(OnGeocodingListener geocodingListener, OnReverseGeocodingListener reverseGeocodingListener) {
            if (this.provider == null) {
                throw new RuntimeException("A provider must be initialized");
            }
            if (this.directAdded && geocodingListener == null) {
                this.smartLocation.logger.w("Some places were added for geocoding but the listener was not specified!", new Object[0]);
            }
            if (this.reverseAdded && reverseGeocodingListener == null) {
                this.smartLocation.logger.w("Some places were added for reverse geocoding but the listener was not specified!", new Object[0]);
            }
            this.provider.start(geocodingListener, reverseGeocodingListener);
        }

        public void stop() {
            this.provider.stop();
        }
    }

    public static class LocationControl {
        private static final Map<Context, LocationProvider> MAPPING = new WeakHashMap<Context, LocationProvider>();
        private final SmartLocation smartLocation;
        private LocationParams params;
        private LocationProvider provider;
        private boolean oneFix;

        public LocationControl(@NonNull SmartLocation smartLocation, @NonNull LocationProvider locationProvider) {
            this.smartLocation = smartLocation;
            this.params = LocationParams.BEST_EFFORT;
            this.oneFix = false;
            if (!MAPPING.containsKey(smartLocation.context)) {
                MAPPING.put(smartLocation.context, locationProvider);
            }
            this.provider = MAPPING.get(smartLocation.context);
            if (smartLocation.preInitialize) {
                this.provider.init(smartLocation.context, smartLocation.logger);
            }
        }

        public LocationControl config(@NonNull LocationParams params) {
            this.params = params;
            return this;
        }

        public LocationControl oneFix() {
            this.oneFix = true;
            return this;
        }

        public LocationControl continuous() {
            this.oneFix = false;
            return this;
        }

        public LocationState state() {
            return LocationState.with(this.smartLocation.context);
        }

        @Nullable
        public Location getLastLocation() {
            return this.provider.getLastLocation();
        }

        public LocationControl get() {
            return this;
        }

        public void start(OnLocationUpdatedListener listener) {
            if (this.provider == null) {
                throw new RuntimeException("A provider must be initialized");
            }
            this.provider.start(listener, this.params, this.oneFix);
        }

        public void stop() {
            this.provider.stop();
        }
    }

    public static class Builder {
        private final Context context;
        private boolean loggingEnabled;
        private boolean preInitialize;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.loggingEnabled = false;
            this.preInitialize = true;
        }

        public Builder logging(boolean enabled) {
            this.loggingEnabled = enabled;
            return this;
        }

        public Builder preInitialize(boolean enabled) {
            this.preInitialize = enabled;
            return this;
        }

        public SmartLocation build() {
            return new SmartLocation(this.context, LoggerFactory.buildLogger(this.loggingEnabled), this.preInitialize);
        }
    }
}

