/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver;

import io.netty5.resolver.NameResolver;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.util.List;
import java.util.Objects;

public abstract class SimpleNameResolver<T>
implements NameResolver<T> {
    private final EventExecutor executor;

    protected SimpleNameResolver(EventExecutor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public final Future<T> resolve(String inetHost) {
        Promise promise = this.executor().newPromise();
        return this.resolve(inetHost, promise);
    }

    @Override
    public Future<T> resolve(String inetHost, Promise<T> promise) {
        Objects.requireNonNull(promise, "promise");
        try {
            this.doResolve(inetHost, promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
        }
        return promise.asFuture();
    }

    @Override
    public final Future<List<T>> resolveAll(String inetHost) {
        Promise promise = this.executor().newPromise();
        return this.resolveAll(inetHost, promise);
    }

    @Override
    public Future<List<T>> resolveAll(String inetHost, Promise<List<T>> promise) {
        Objects.requireNonNull(promise, "promise");
        try {
            this.doResolveAll(inetHost, promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
        }
        return promise.asFuture();
    }

    protected abstract void doResolve(String var1, Promise<T> var2) throws Exception;

    protected abstract void doResolveAll(String var1, Promise<List<T>> var2) throws Exception;

    @Override
    public void close() {
    }
}

