/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.rtsp;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.DefaultFullHttpRequest;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.DefaultHttpRequest;
import io.netty5.handler.codec.http.DefaultHttpResponse;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpObjectDecoder;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.rtsp.RtspHeaderNames;
import io.netty5.handler.codec.rtsp.RtspMethods;
import io.netty5.handler.codec.rtsp.RtspVersions;
import java.util.regex.Pattern;

public class RtspDecoder
extends HttpObjectDecoder {
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private boolean isDecodingRequest;
    private static final Pattern versionPattern = Pattern.compile("RTSP/\\d\\.\\d");
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 8192;

    public RtspDecoder() {
        this(4096, 8192, 8192);
    }

    public RtspDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(maxInitialLineLength, maxHeaderSize, false);
    }

    public RtspDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength, boolean validateHeaders) {
        super(maxInitialLineLength, maxHeaderSize, false, validateHeaders);
    }

    @Override
    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        if (versionPattern.matcher(initialLine[0]).matches()) {
            this.isDecodingRequest = false;
            return new DefaultHttpResponse(RtspVersions.valueOf(initialLine[0]), new HttpResponseStatus(Integer.parseInt(initialLine[1]), initialLine[2]), this.validateHeaders);
        }
        this.isDecodingRequest = true;
        return new DefaultHttpRequest(RtspVersions.valueOf(initialLine[2]), RtspMethods.valueOf(initialLine[0]), initialLine[1], this.validateHeaders);
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        return super.isContentAlwaysEmpty(msg) || !msg.headers().contains((CharSequence)RtspHeaderNames.CONTENT_LENGTH);
    }

    @Override
    protected HttpMessage createInvalidMessage(ChannelHandlerContext ctx) {
        if (this.isDecodingRequest) {
            return new DefaultFullHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.OPTIONS, "/bad-request", ctx.bufferAllocator().allocate(0), this.validateHeaders);
        }
        return new DefaultFullHttpResponse(RtspVersions.RTSP_1_0, UNKNOWN_STATUS, ctx.bufferAllocator().allocate(0), this.validateHeaders);
    }

    @Override
    protected boolean isDecodingRequest() {
        return this.isDecodingRequest;
    }
}

