/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.channel.Channel;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import io.netty5.handler.codec.http.websocketx.WebSocketVersion;
import io.netty5.util.AsciiString;
import io.netty5.util.concurrent.Future;
import java.util.Objects;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final WebSocketDecoderConfig decoderConfig;

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, 65536);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this(webSocketURL, subprotocols, WebSocketDecoderConfig.newBuilder().allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(allowMaskMismatch).build());
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        this.webSocketURL = webSocketURL;
        this.subprotocols = subprotocols;
        this.decoderConfig = Objects.requireNonNull(decoderConfig, "decoderConfig");
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest req) {
        CharSequence version = req.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION);
        if (version != null && AsciiString.contentEqualsIgnoreCase((CharSequence)version, (CharSequence)WebSocketVersion.V13.toAsciiString())) {
            return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.decoderConfig);
        }
        return null;
    }

    @Deprecated
    public static void sendUnsupportedWebSocketVersionResponse(Channel channel) {
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
    }

    public static Future<Void> sendUnsupportedVersionResponse(Channel channel) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED, channel.bufferAllocator().allocate(0));
        res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue());
        HttpUtil.setContentLength(res, 0L);
        return channel.writeAndFlush((Object)res);
    }
}

