/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.http.DefaultFullHttpRequest;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty5.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty5.handler.codec.http.websocketx.WebSocketUtil;
import io.netty5.handler.codec.http.websocketx.WebSocketVersion;
import io.netty5.util.AsciiString;
import io.netty5.util.internal.StringUtil;
import java.net.URI;

public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;
    private volatile String sentNonce;

    public WebSocketClientHandshaker13(URI webSocketURL, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(webSocketURL, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, true, false);
    }

    public WebSocketClientHandshaker13(URI webSocketURL, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch) {
        this(webSocketURL, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, 10000L);
    }

    public WebSocketClientHandshaker13(URI webSocketURL, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis) {
        this(webSocketURL, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, false);
    }

    WebSocketClientHandshaker13(URI webSocketURL, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl) {
        super(webSocketURL, WebSocketVersion.V13, subprotocol, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, absoluteUpgradeUrl);
        this.allowExtensions = allowExtensions;
        this.performMasking = performMasking;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest(BufferAllocator allocator) {
        URI wsURL = this.uri();
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(wsURL), allocator.allocate(0));
        HttpHeaders headers = request.headers();
        if (this.customHeaders != null) {
            headers.add(this.customHeaders);
            if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
                headers.set((CharSequence)HttpHeaderNames.HOST, WebSocketClientHandshaker13.websocketHostValue(wsURL));
            }
        } else {
            headers.set((CharSequence)HttpHeaderNames.HOST, WebSocketClientHandshaker13.websocketHostValue(wsURL));
        }
        String nonce = WebSocketClientHandshaker13.createNonce();
        headers.set((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (CharSequence)nonce);
        this.sentNonce = nonce;
        String expectedSubprotocol = this.expectedSubprotocol();
        if (!StringUtil.isNullOrEmpty((CharSequence)expectedSubprotocol)) {
            headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (CharSequence)expectedSubprotocol);
        }
        headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)this.version().toAsciiString());
        return request;
    }

    @Override
    protected void verify(FullHttpResponse response) {
        HttpResponseStatus status = response.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(status)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response status: " + status, response);
        }
        HttpHeaders headers = response.headers();
        CharSequence upgrade = headers.get((CharSequence)HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(upgrade)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + upgrade, response);
        }
        if (!headers.containsIgnoreCase((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + headers.get((CharSequence)HttpHeaderNames.CONNECTION), response);
        }
        CharSequence accept = headers.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (accept == null) {
            throw new WebSocketClientHandshakeException("Invalid handshake response sec-websocket-accept: null", response);
        }
        String expectedAccept = WebSocketUtil.calculateV13Accept(this.sentNonce);
        if (!AsciiString.contentEquals((CharSequence)expectedAccept, (CharSequence)AsciiString.trim((CharSequence)accept))) {
            throw new WebSocketClientHandshakeException("Invalid handshake response sec-websocket-accept: " + accept + ", expected: " + expectedAccept, response);
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(this.performMasking);
    }

    @Override
    public WebSocketClientHandshaker13 setForceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
        super.setForceCloseTimeoutMillis(forceCloseTimeoutMillis);
        return this;
    }

    private static String createNonce() {
        byte[] nonce = WebSocketUtil.randomBytes(16);
        return WebSocketUtil.base64(nonce);
    }
}

