/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.CombinedChannelDuplexHandler;
import io.netty5.channel.internal.DelegatingChannelHandlerContext;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpRequestDecoder;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseEncoder;
import io.netty5.handler.codec.http.HttpServerUpgradeHandler;
import io.netty5.handler.codec.http.HttpStatusClass;
import java.util.ArrayDeque;
import java.util.Queue;

public final class HttpServerCodec
extends CombinedChannelDuplexHandler<HttpRequestDecoder, HttpResponseEncoder>
implements HttpServerUpgradeHandler.SourceCodec {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();

    public HttpServerCodec() {
        this(4096, 8192);
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize) {
        this.init((ChannelHandler)new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize), (ChannelHandler)new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders) {
        this.init((ChannelHandler)new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize, validateHeaders), (ChannelHandler)new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders, int initialBufferSize) {
        this.init((ChannelHandler)new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize, validateHeaders, initialBufferSize), (ChannelHandler)new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths) {
        this.init((ChannelHandler)new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize, validateHeaders, initialBufferSize, allowDuplicateContentLengths), (ChannelHandler)new HttpServerResponseEncoder());
    }

    @Override
    public void upgradeFrom(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private final class HttpServerResponseEncoder
    extends HttpResponseEncoder {
        private HttpMethod method;

        private HttpServerResponseEncoder() {
        }

        @Override
        protected void sanitizeHeadersBeforeEncode(HttpResponse msg, boolean isAlwaysEmpty) {
            if (!isAlwaysEmpty && HttpMethod.CONNECT.equals(this.method) && msg.status().codeClass() == HttpStatusClass.SUCCESS) {
                msg.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                return;
            }
            super.sanitizeHeadersBeforeEncode(msg, isAlwaysEmpty);
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpResponse msg) {
            this.method = HttpServerCodec.this.queue.poll();
            return HttpMethod.HEAD.equals(this.method) || super.isContentAlwaysEmpty(msg);
        }
    }

    private final class HttpServerRequestDecoder
    extends HttpRequestDecoder {
        private ChannelHandlerContext context;

        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize) {
            super(maxInitialLineLength, maxHeaderSize);
        }

        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders) {
            super(maxInitialLineLength, maxHeaderSize, validateHeaders);
        }

        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders, int initialBufferSize) {
            super(maxInitialLineLength, maxHeaderSize, validateHeaders, initialBufferSize);
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
            super.decode(this.context, buffer);
        }

        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths) {
            super(maxInitialLineLength, maxHeaderSize, validateHeaders, initialBufferSize, allowDuplicateContentLengths);
        }

        protected void handlerAdded0(ChannelHandlerContext ctx) {
            this.context = new DelegatingChannelHandlerContext(ctx){

                public ChannelHandlerContext fireChannelRead(Object msg) {
                    if (msg instanceof HttpRequest) {
                        HttpServerCodec.this.queue.add(((HttpRequest)msg).method());
                    }
                    super.fireChannelRead(msg);
                    return this;
                }
            };
        }
    }
}

