/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.handler.codec.PrematureChannelClosureException;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.handler.codec.http.DefaultHttpContent;
import io.netty5.handler.codec.http.DefaultLastHttpContent;
import io.netty5.handler.codec.http.EmptyLastHttpContent;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpExpectationFailedEvent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpMessageDecoderResult;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.TooLongHttpHeaderException;
import io.netty5.handler.codec.http.TooLongHttpLineException;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.AsciiString;
import io.netty5.util.ByteProcessor;
import io.netty5.util.internal.AppendableCharSequence;
import io.netty5.util.internal.ObjectUtil;
import java.util.Iterator;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final boolean DEFAULT_CHUNKED_SUPPORTED = true;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    public static final boolean DEFAULT_ALLOW_DUPLICATE_CONTENT_LENGTHS = false;
    private static final String EMPTY_VALUE = "";
    private final boolean chunkedSupported;
    protected final boolean validateHeaders;
    private final boolean allowDuplicateContentLengths;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private volatile boolean resetRequested;
    private CharSequence name;
    private CharSequence value;
    private LastHttpContent<?> trailer;
    private State currentState = State.SKIP_CONTROL_CHARS;

    protected HttpObjectDecoder() {
        this(4096, 8192, true);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, boolean chunkedSupported) {
        this(maxInitialLineLength, maxHeaderSize, chunkedSupported, true);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, boolean chunkedSupported, boolean validateHeaders) {
        this(maxInitialLineLength, maxHeaderSize, chunkedSupported, validateHeaders, 128);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, boolean chunkedSupported, boolean validateHeaders, int initialBufferSize) {
        this(maxInitialLineLength, maxHeaderSize, chunkedSupported, validateHeaders, initialBufferSize, false);
    }

    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, boolean chunkedSupported, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths) {
        ObjectUtil.checkPositive((int)maxInitialLineLength, (String)"maxInitialLineLength");
        ObjectUtil.checkPositive((int)maxHeaderSize, (String)"maxHeaderSize");
        AppendableCharSequence seq = new AppendableCharSequence(initialBufferSize);
        this.lineParser = new LineParser(seq, maxInitialLineLength);
        this.headerParser = new HeaderParser(seq, maxHeaderSize);
        this.chunkedSupported = chunkedSupported;
        this.validateHeaders = validateHeaders;
        this.allowDuplicateContentLengths = allowDuplicateContentLengths;
    }

    protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        if (this.resetRequested) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                try {
                    AppendableCharSequence line = this.lineParser.parse(buffer);
                    if (line == null) {
                        return;
                    }
                    String[] initialLine = HttpObjectDecoder.splitInitialLine(line);
                    if (initialLine.length < 3) {
                        this.currentState = State.SKIP_CONTROL_CHARS;
                        return;
                    }
                    this.message = this.createMessage(initialLine);
                    this.currentState = State.READ_HEADER;
                }
                catch (Exception e) {
                    ctx.fireChannelRead((Object)this.invalidMessage(ctx, buffer, e));
                    return;
                }
            }
            case READ_HEADER: {
                try {
                    State nextState = this.readHeaders(buffer);
                    if (nextState == null) {
                        return;
                    }
                    this.currentState = nextState;
                    switch (nextState) {
                        case SKIP_CONTROL_CHARS: {
                            ctx.fireChannelRead((Object)this.message);
                            ctx.fireChannelRead((Object)new EmptyLastHttpContent(ctx.bufferAllocator()));
                            this.resetNow();
                            return;
                        }
                        case READ_CHUNK_SIZE: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            ctx.fireChannelRead((Object)this.message);
                            return;
                        }
                    }
                    long contentLength = this.contentLength();
                    if (contentLength == 0L || contentLength == -1L && this.isDecodingRequest()) {
                        ctx.fireChannelRead((Object)this.message);
                        ctx.fireChannelRead((Object)new EmptyLastHttpContent(ctx.bufferAllocator()));
                        this.resetNow();
                        return;
                    }
                    assert (nextState == State.READ_FIXED_LENGTH_CONTENT || nextState == State.READ_VARIABLE_LENGTH_CONTENT);
                    ctx.fireChannelRead((Object)this.message);
                    if (nextState == State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = contentLength;
                    }
                    return;
                }
                catch (Exception e) {
                    ctx.fireChannelRead((Object)this.invalidMessage(ctx, buffer, e));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = buffer.readableBytes();
                if (toRead > 0) {
                    Buffer content = buffer.split();
                    ctx.fireChannelRead((Object)new DefaultHttpContent(content));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int toRead = buffer.readableBytes();
                if (toRead == 0) {
                    return;
                }
                if ((long)toRead > this.chunkSize) {
                    toRead = (int)this.chunkSize;
                }
                Buffer content = buffer.readSplit(toRead);
                this.chunkSize -= (long)toRead;
                if (this.chunkSize == 0L) {
                    ctx.fireChannelRead((Object)new DefaultLastHttpContent(content, this.validateHeaders));
                    this.resetNow();
                } else {
                    ctx.fireChannelRead((Object)new DefaultHttpContent(content));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    AppendableCharSequence line = this.lineParser.parse(buffer);
                    if (line == null) {
                        return;
                    }
                    int chunkSize = HttpObjectDecoder.getChunkSize(line.toString());
                    this.chunkSize = chunkSize;
                    if (chunkSize == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception e) {
                    ctx.fireChannelRead(this.invalidChunk(ctx.bufferAllocator(), buffer, e));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int toRead = (int)this.chunkSize;
                if ((toRead = Math.min(toRead, buffer.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent chunk = new DefaultHttpContent(buffer.readSplit(toRead));
                this.chunkSize -= (long)toRead;
                ctx.fireChannelRead((Object)chunk);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int bytesToSkip = buffer.bytesBefore((byte)10) + 1;
                if (bytesToSkip > 0) {
                    this.currentState = State.READ_CHUNK_SIZE;
                    buffer.skipReadableBytes(bytesToSkip);
                } else {
                    buffer.skipReadableBytes(buffer.readableBytes());
                }
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent<?> trailer = this.readTrailingHeaders(ctx.bufferAllocator(), buffer);
                    if (trailer == null) {
                        return;
                    }
                    ctx.fireChannelRead(trailer);
                    this.resetNow();
                    return;
                }
                catch (Exception e) {
                    ctx.fireChannelRead(this.invalidChunk(ctx.bufferAllocator(), buffer, e));
                    return;
                }
            }
            case BAD_MESSAGE: {
                buffer.skipReadableBytes(buffer.readableBytes());
                break;
            }
            case UPGRADED: {
                int readableBytes = buffer.readableBytes();
                if (readableBytes <= 0) break;
                ctx.fireChannelRead((Object)buffer.split());
                break;
            }
        }
    }

    protected void decodeLast(ChannelHandlerContext ctx, Buffer in) throws Exception {
        super.decodeLast(ctx, in);
        if (this.resetRequested) {
            this.resetNow();
        }
        if (this.message != null) {
            boolean prematureClosure;
            boolean chunked = HttpUtil.isTransferEncodingChunked(this.message);
            if (this.currentState == State.READ_VARIABLE_LENGTH_CONTENT && in.readableBytes() == 0 && !chunked) {
                ctx.fireChannelRead((Object)new EmptyLastHttpContent(ctx.bufferAllocator()));
                this.resetNow();
                return;
            }
            if (this.currentState == State.READ_HEADER) {
                ctx.fireChannelRead((Object)this.invalidMessage(ctx, (Exception)new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            if (this.isDecodingRequest() || chunked) {
                prematureClosure = true;
            } else {
                boolean bl = prematureClosure = this.contentLength() > 0L;
            }
            if (!prematureClosure) {
                ctx.fireChannelRead((Object)new EmptyLastHttpContent(ctx.bufferAllocator()));
            }
            this.resetNow();
        }
    }

    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                    break;
                }
            }
        }
        super.channelInboundEvent(ctx, evt);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.status().code();
            if (code >= 100 && code < 200) {
                return true;
            }
            return code == 204 || code == 304;
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse msg) {
        if (msg.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        CharSequence newProtocol = msg.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
        return newProtocol == null || !AsciiString.contains((CharSequence)newProtocol, (CharSequence)HttpVersion.HTTP_1_0.text()) && !AsciiString.contains((CharSequence)newProtocol, (CharSequence)HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested = true;
    }

    private void resetNow() {
        HttpResponse res;
        HttpMessage message = this.message;
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (!this.isDecodingRequest() && (res = (HttpResponse)message) != null && this.isSwitchingToNonHttp1Protocol(res)) {
            this.currentState = State.UPGRADED;
            return;
        }
        this.resetRequested = false;
        this.currentState = State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(ChannelHandlerContext ctx, Buffer in, Exception cause) {
        in.skipReadableBytes(in.readableBytes());
        return this.invalidMessage(ctx, cause);
    }

    private HttpMessage invalidMessage(ChannelHandlerContext ctx, Exception cause) {
        this.currentState = State.BAD_MESSAGE;
        if (this.message == null) {
            this.message = this.createInvalidMessage(ctx);
        }
        this.message.setDecoderResult(DecoderResult.failure((Throwable)cause));
        HttpMessage ret = this.message;
        this.message = null;
        return ret;
    }

    private HttpContent<?> invalidChunk(BufferAllocator allocator, Buffer in, Exception cause) {
        this.currentState = State.BAD_MESSAGE;
        in.skipReadableBytes(in.readableBytes());
        DefaultLastHttpContent chunk = new DefaultLastHttpContent(allocator.allocate(0));
        chunk.setDecoderResult(DecoderResult.failure((Throwable)cause));
        this.message = null;
        this.trailer = null;
        return chunk;
    }

    private State readHeaders(Buffer buffer) {
        HttpMessage message = this.message;
        HttpHeaders headers = message.headers();
        AppendableCharSequence line = this.headerParser.parse(buffer);
        if (line == null) {
            return null;
        }
        if (line.length() > 0) {
            do {
                char firstChar = line.charAtUnsafe(0);
                if (this.name != null && (firstChar == ' ' || firstChar == '\t')) {
                    String trimmedLine = line.toString().trim();
                    String valueStr = String.valueOf(this.value);
                    this.value = valueStr + " " + trimmedLine;
                } else {
                    if (this.name != null) {
                        headers.add(this.name, this.value);
                    }
                    this.splitHeader(line);
                }
                line = this.headerParser.parse(buffer);
                if (line != null) continue;
                return null;
            } while (line.length() > 0);
        }
        if (this.name != null) {
            headers.add(this.name, this.value);
        }
        this.name = null;
        this.value = null;
        HttpMessageDecoderResult decoderResult = new HttpMessageDecoderResult(this.lineParser.size, this.headerParser.size);
        message.setDecoderResult(decoderResult);
        Iterator<CharSequence> contentLengthFields = headers.valuesIterator((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        boolean hasContentLength = contentLengthFields.hasNext();
        if (hasContentLength) {
            HttpVersion version = message.protocolVersion();
            boolean isHttp10OrEarlier = version.majorVersion() < 1 || version.majorVersion() == 1 && version.minorVersion() == 0;
            this.contentLength = HttpUtil.normalizeAndGetContentLength(contentLengthFields, isHttp10OrEarlier, this.allowDuplicateContentLengths);
            if (this.contentLength != -1L) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(this.contentLength));
            }
        }
        if (this.isContentAlwaysEmpty(message)) {
            HttpUtil.setTransferEncodingChunked(message, false);
            return State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(message)) {
            if (hasContentLength && message.protocolVersion() == HttpVersion.HTTP_1_1) {
                this.handleTransferEncodingChunkedWithContentLength(message);
            }
            return State.READ_CHUNK_SIZE;
        }
        if (this.contentLength() >= 0L) {
            return State.READ_FIXED_LENGTH_CONTENT;
        }
        return State.READ_VARIABLE_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage message) {
        message.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HttpUtil.getContentLength(this.message, -1L);
        }
        return this.contentLength;
    }

    private LastHttpContent<?> readTrailingHeaders(BufferAllocator allocator, Buffer buffer) {
        AppendableCharSequence line = this.headerParser.parse(buffer);
        if (line == null) {
            return null;
        }
        DefaultLastHttpContent trailer = this.trailer;
        if (line.length() == 0 && trailer == null) {
            return new EmptyLastHttpContent(allocator);
        }
        CharSequence lastHeader = null;
        if (trailer == null) {
            trailer = this.trailer = new DefaultLastHttpContent(allocator.allocate(0), this.validateHeaders);
        }
        while (line.length() > 0) {
            char firstChar = line.charAtUnsafe(0);
            if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                Iterator<CharSequence> itr = trailer.trailingHeaders().valuesIterator(lastHeader);
                CharSequence last = null;
                while (itr.hasNext()) {
                    last = itr.next();
                }
                if (last != null) {
                    itr.remove();
                    String lineTrimmed = line.toString().trim();
                    trailer.trailingHeaders().add(lastHeader, (CharSequence)(last + lineTrimmed));
                }
            } else {
                this.splitHeader(line);
                CharSequence headerName = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(headerName) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(headerName) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase(headerName))) {
                    trailer.trailingHeaders().add(headerName, this.value);
                }
                lastHeader = this.name;
                this.name = null;
                this.value = null;
            }
            if ((line = this.headerParser.parse(buffer)) != null) continue;
            return null;
        }
        this.trailer = null;
        return trailer;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    protected abstract HttpMessage createInvalidMessage(ChannelHandlerContext var1);

    private static int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    private static String[] splitInitialLine(AppendableCharSequence sb) {
        int aStart = HttpObjectDecoder.findNonSPLenient(sb, 0);
        int aEnd = HttpObjectDecoder.findSPLenient(sb, aStart);
        int bStart = HttpObjectDecoder.findNonSPLenient(sb, aEnd);
        int bEnd = HttpObjectDecoder.findSPLenient(sb, bStart);
        int cStart = HttpObjectDecoder.findNonSPLenient(sb, bEnd);
        int cEnd = HttpObjectDecoder.findEndOfString(sb);
        return new String[]{sb.subStringUnsafe(aStart, aEnd), sb.subStringUnsafe(bStart, bEnd), cStart < cEnd ? sb.subStringUnsafe(cStart, cEnd) : EMPTY_VALUE};
    }

    private void splitHeader(AppendableCharSequence sb) {
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpObjectDecoder.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAtUnsafe(nameEnd)) != ':' && (this.isDecodingRequest() || !HttpObjectDecoder.isOWS(ch)); ++nameEnd) {
        }
        if (nameEnd == length) {
            throw new IllegalArgumentException("No colon found");
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAtUnsafe(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        this.name = sb.subStringUnsafe(nameStart, nameEnd);
        int valueStart = HttpObjectDecoder.findNonWhitespace(sb, colonEnd);
        if (valueStart == length) {
            this.value = EMPTY_VALUE;
        } else {
            int valueEnd = HttpObjectDecoder.findEndOfString(sb);
            this.value = sb.subStringUnsafe(valueStart, valueEnd);
        }
    }

    private static int findNonSPLenient(AppendableCharSequence sb, int offset) {
        for (int result = offset; result < sb.length(); ++result) {
            char c = sb.charAtUnsafe(result);
            if (HttpObjectDecoder.isSPLenient(c)) continue;
            if (Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Invalid separator");
            }
            return result;
        }
        return sb.length();
    }

    private static int findSPLenient(AppendableCharSequence sb, int offset) {
        for (int result = offset; result < sb.length(); ++result) {
            if (!HttpObjectDecoder.isSPLenient(sb.charAtUnsafe(result))) continue;
            return result;
        }
        return sb.length();
    }

    private static boolean isSPLenient(char c) {
        return c == ' ' || c == '\t' || c == '\u000b' || c == '\f' || c == '\r';
    }

    private static int findNonWhitespace(AppendableCharSequence sb, int offset) {
        for (int result = offset; result < sb.length(); ++result) {
            char c = sb.charAtUnsafe(result);
            if (!Character.isWhitespace(c)) {
                return result;
            }
            if (HttpObjectDecoder.isOWS(c)) continue;
            throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + c + "' (0x" + Integer.toHexString(c) + ")");
        }
        return sb.length();
    }

    private static int findEndOfString(AppendableCharSequence sb) {
        for (int result = sb.length() - 1; result > 0; --result) {
            if (Character.isWhitespace(sb.charAtUnsafe(result))) continue;
            return result + 1;
        }
        return 0;
    }

    private static boolean isOWS(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private final class LineParser
    extends HeaderParser {
        LineParser(AppendableCharSequence seq, int maxLength) {
            super(seq, maxLength);
        }

        @Override
        public AppendableCharSequence parse(Buffer buffer) {
            this.reset();
            return super.parse(buffer);
        }

        @Override
        public boolean process(byte value) {
            if (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS) {
                char c = (char)(value & 0xFF);
                if (Character.isISOControl(c) || Character.isWhitespace(c)) {
                    this.increaseCount();
                    return true;
                }
                HttpObjectDecoder.this.currentState = State.READ_INITIAL;
            }
            return super.process(value);
        }

        @Override
        protected TooLongFrameException newException(int maxLength) {
            return new TooLongHttpLineException("An HTTP line is larger than " + maxLength + " bytes.");
        }
    }

    private static class HeaderParser
    implements ByteProcessor {
        private final AppendableCharSequence seq;
        private final int maxLength;
        int size;

        HeaderParser(AppendableCharSequence seq, int maxLength) {
            this.seq = seq;
            this.maxLength = maxLength;
        }

        public AppendableCharSequence parse(Buffer buffer) {
            int oldSize = this.size;
            this.seq.reset();
            int i = buffer.openCursor().process((ByteProcessor)this);
            if (i == -1) {
                this.size = oldSize;
                return null;
            }
            buffer.skipReadableBytes(i + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        public boolean process(byte value) {
            char nextByte = (char)(value & 0xFF);
            if (nextByte == '\n') {
                int len = this.seq.length();
                if (len >= 1 && this.seq.charAtUnsafe(len - 1) == '\r') {
                    --this.size;
                    this.seq.setLength(len - 1);
                }
                return false;
            }
            this.increaseCount();
            this.seq.append(nextByte);
            return true;
        }

        protected final void increaseCount() {
            if (++this.size > this.maxLength) {
                throw this.newException(this.maxLength);
            }
        }

        protected TooLongFrameException newException(int maxLength) {
            return new TooLongHttpHeaderException("HTTP header is larger than " + maxLength + " bytes.");
        }
    }

    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

