/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.Send;
import java.util.Objects;

public final class EmptyLastHttpContent
implements LastHttpContent<EmptyLastHttpContent> {
    private final Buffer payload;
    private final BufferAllocator allocator;

    public EmptyLastHttpContent(BufferAllocator allocator) {
        this.payload = allocator.allocate(0);
        this.allocator = allocator;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    @Override
    public EmptyLastHttpContent copy() {
        return new EmptyLastHttpContent(this.allocator);
    }

    public Send<EmptyLastHttpContent> send() {
        return Send.sending(EmptyLastHttpContent.class, () -> new EmptyLastHttpContent(this.allocator));
    }

    public void close() {
        this.payload.close();
    }

    public boolean isAccessible() {
        return this.payload.isAccessible();
    }

    public EmptyLastHttpContent touch(Object hint) {
        this.payload.touch(hint);
        return this;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return HttpHeaders.emptyHeaders();
    }

    public DecoderResult decoderResult() {
        return DecoderResult.success();
    }

    public void setDecoderResult(DecoderResult result) {
        throw new UnsupportedOperationException("read only");
    }

    public String toString() {
        return "EmptyLastHttpContent";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmptyLastHttpContent that = (EmptyLastHttpContent)o;
        return Objects.equals(this.payload, that.payload) && Objects.equals(this.allocator, that.allocator);
    }

    public int hashCode() {
        int result = this.payload != null ? this.payload.hashCode() : 0;
        result = 31 * result + (this.allocator != null ? this.allocator.hashCode() : 0);
        return result;
    }
}

