/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferClosedException;
import io.netty5.handler.codec.http.DefaultHttpRequest;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.HttpMessageUtil;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.Send;
import java.util.Objects;

public class DefaultFullHttpRequest
extends DefaultHttpRequest
implements FullHttpRequest {
    private final Buffer payload;
    private final HttpHeaders trailingHeader;
    private int hash;

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, Buffer payload) {
        this(httpVersion, method, uri, payload, true);
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, Buffer payload, boolean validateHeaders) {
        super(httpVersion, method, uri, validateHeaders);
        this.payload = Objects.requireNonNull(payload, "payload");
        this.trailingHeader = HttpHeaders.newHeaders(validateHeaders);
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, Buffer payload, HttpHeaders headers, HttpHeaders trailingHeader) {
        super(httpVersion, method, uri, headers);
        this.payload = Objects.requireNonNull(payload, "payload");
        this.trailingHeader = Objects.requireNonNull(trailingHeader, "trailingHeader");
    }

    public void close() {
        this.payload.close();
    }

    public boolean isAccessible() {
        return this.payload.isAccessible();
    }

    public FullHttpRequest touch(Object hint) {
        this.payload.touch(hint);
        return this;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    public Send<FullHttpRequest> send() {
        return this.payload.send().map(FullHttpRequest.class, payload -> new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), (Buffer)payload, this.headers(), this.trailingHeader));
    }

    @Override
    public FullHttpRequest copy() {
        return new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), this.payload.copy(), this.headers().copy(), this.trailingHeader.copy());
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeader;
    }

    @Override
    public FullHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FullHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public FullHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash == 0) {
            Buffer payload = this.payload();
            if (payload.isAccessible()) {
                try {
                    hash = 31 + payload.hashCode();
                }
                catch (BufferClosedException ignored) {
                    hash = 31;
                }
            } else {
                hash = 31;
            }
            hash = 31 * hash + this.trailingHeaders().hashCode();
            this.hash = hash = 31 * hash + super.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultFullHttpRequest)) {
            return false;
        }
        DefaultFullHttpRequest other = (DefaultFullHttpRequest)o;
        return super.equals(other) && this.payload().equals(other.payload()) && this.trailingHeaders().equals(other.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
    }
}

