/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.Native;
import io.netty.channel.uring.RingBuffer;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class IoUring {
    private static final Throwable UNAVAILABILITY_CAUSE;
    private static final boolean IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED;
    private static final boolean IORING_SPLICE_SUPPORTED;
    private static final boolean IORING_ACCEPT_NO_WAIT_SUPPORTED;
    private static final boolean IORING_ACCEPT_MULTISHOT_SUPPORTED;
    private static final boolean IORING_RECV_MULTISHOT_SUPPORTED;
    private static final boolean IORING_RECVSEND_BUNDLE_SUPPORTED;
    private static final boolean IORING_POLL_ADD_MULTISHOT_SUPPORTED;
    private static final boolean IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED;
    private static final boolean IORING_SETUP_SUBMIT_ALL_SUPPORTED;
    private static final boolean IORING_SETUP_CQ_SIZE_SUPPORTED;
    private static final boolean IORING_SETUP_SINGLE_ISSUER_SUPPORTED;
    private static final boolean IORING_SETUP_DEFER_TASKRUN_SUPPORTED;
    private static final boolean IORING_REGISTER_BUFFER_RING_SUPPORTED;
    private static final boolean IORING_REGISTER_BUFFER_RING_INC_SUPPORTED;
    private static final InternalLogger logger;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return IoUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return IoUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    static boolean isCqeFSockNonEmptySupported() {
        return IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED;
    }

    static boolean isSpliceSupported() {
        return IORING_SPLICE_SUPPORTED;
    }

    static boolean isAcceptNoWaitSupported() {
        return IORING_ACCEPT_NO_WAIT_SUPPORTED;
    }

    static boolean isAcceptMultishotSupported() {
        return IORING_ACCEPT_MULTISHOT_SUPPORTED;
    }

    static boolean isRecvMultishotSupported() {
        return IORING_RECV_MULTISHOT_SUPPORTED;
    }

    static boolean isRecvsendBundleSupported() {
        return IORING_RECVSEND_BUNDLE_SUPPORTED;
    }

    static boolean isPollAddMultishotSupported() {
        return IORING_POLL_ADD_MULTISHOT_SUPPORTED;
    }

    static boolean isRegisterIowqMaxWorkersSupported() {
        return IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED;
    }

    static boolean isSetupCqeSizeSupported() {
        return IORING_SETUP_CQ_SIZE_SUPPORTED;
    }

    static boolean isSetupSubmitAllSupported() {
        return IORING_SETUP_SUBMIT_ALL_SUPPORTED;
    }

    static boolean isSetupSingleIssuerSupported() {
        return IORING_SETUP_SINGLE_ISSUER_SUPPORTED;
    }

    static boolean isSetupDeferTaskrunSupported() {
        return IORING_SETUP_DEFER_TASKRUN_SUPPORTED;
    }

    public static boolean isRegisterBufferRingSupported() {
        return IORING_REGISTER_BUFFER_RING_SUPPORTED;
    }

    public static boolean isRegisterBufferRingIncSupported() {
        return IORING_REGISTER_BUFFER_RING_INC_SUPPORTED;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private IoUring() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean registerBufferRingIncSupported;
        boolean registerBufferRingSupported;
        boolean deferTaskrunSupported;
        boolean singleIssuerSupported;
        boolean setUpCqSizeSupported;
        boolean submitAllSupported;
        boolean registerIowqWorkersSupported;
        boolean pollAddMultishotSupported;
        boolean recvMultishotSupported;
        boolean recvsendBundleSupported;
        boolean acceptMultishotSupported;
        boolean acceptSupportNoWait;
        boolean spliceSupported;
        boolean socketNonEmptySupported;
        Throwable cause;
        block18: {
            logger = InternalLoggerFactory.getInstance(IoUring.class);
            cause = null;
            socketNonEmptySupported = false;
            spliceSupported = false;
            acceptSupportNoWait = false;
            acceptMultishotSupported = false;
            recvsendBundleSupported = false;
            recvMultishotSupported = false;
            pollAddMultishotSupported = false;
            registerIowqWorkersSupported = false;
            submitAllSupported = false;
            setUpCqSizeSupported = false;
            singleIssuerSupported = false;
            deferTaskrunSupported = false;
            registerBufferRingSupported = false;
            registerBufferRingIncSupported = false;
            try {
                if (SystemPropertyUtil.getBoolean((String)"io.netty.transport.noNative", (boolean)false)) {
                    cause = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
                    break block18;
                }
                String kernelVersion = Native.kernelVersion();
                Native.checkKernelVersion(kernelVersion);
                Throwable unsafeCause = PlatformDependent.getUnsafeUnavailabilityCause();
                if (unsafeCause == null) {
                    RingBuffer ringBuffer = null;
                    try {
                        ringBuffer = Native.createRingBuffer(1, 0);
                        Native.checkAllIOSupported(ringBuffer.fd());
                        socketNonEmptySupported = Native.isCqeFSockNonEmptySupported(ringBuffer.fd());
                        spliceSupported = Native.isSpliceSupported(ringBuffer.fd());
                        acceptSupportNoWait = recvsendBundleSupported = (ringBuffer.features() & 0x4000) != 0;
                        acceptMultishotSupported = Native.isAcceptMultishotSupported(ringBuffer.fd());
                        recvMultishotSupported = Native.isRecvMultishotSupported();
                        pollAddMultishotSupported = Native.isPollAddMultiShotSupported(ringBuffer.fd());
                        registerIowqWorkersSupported = Native.isRegisterIoWqWorkerSupported(ringBuffer.fd());
                        submitAllSupported = Native.ioUringSetupSupportsFlags(128);
                        setUpCqSizeSupported = Native.ioUringSetupSupportsFlags(8);
                        singleIssuerSupported = Native.ioUringSetupSupportsFlags(4096);
                        deferTaskrunSupported = Native.ioUringSetupSupportsFlags(12288);
                        registerBufferRingSupported = Native.isRegisterBufferRingSupported(ringBuffer.fd(), 0);
                        registerBufferRingIncSupported = Native.isRegisterBufferRingSupported(ringBuffer.fd(), 2);
                        break block18;
                    }
                    finally {
                        if (ringBuffer != null) {
                            try {
                                ringBuffer.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                cause = new UnsupportedOperationException("Unsafe is not supported", unsafeCause);
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (cause != null) {
            if (logger.isTraceEnabled()) {
                logger.debug("IoUring support is not available", cause);
            } else if (logger.isDebugEnabled()) {
                logger.debug("IoUring support is not available: {}", (Object)cause.getMessage());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("IoUring support is available (CQE_F_SOCK_NONEMPTY_SUPPORTED={}, SPLICE_SUPPORTED={}, ACCEPT_NO_WAIT_SUPPORTED={}, ACCEPT_MULTISHOT_SUPPORTED={}, POLL_ADD_MULTISHOT_SUPPORTED={} RECV_MULTISHOT_SUPPORTED={}, IORING_RECVSEND_BUNDLE_SUPPORTED={}, REGISTER_IOWQ_MAX_WORKERS_SUPPORTED={}, SETUP_SUBMIT_ALL_SUPPORTED={}, SETUP_SINGLE_ISSUER_SUPPORTED={}, SETUP_DEFER_TASKRUN_SUPPORTED={}, REGISTER_BUFFER_RING_SUPPORTED={}, REGISTER_BUFFER_RING_INC_SUPPORTED={})", new Object[]{socketNonEmptySupported, spliceSupported, acceptSupportNoWait, acceptMultishotSupported, pollAddMultishotSupported, recvMultishotSupported, recvsendBundleSupported, registerIowqWorkersSupported, submitAllSupported, singleIssuerSupported, deferTaskrunSupported, registerBufferRingSupported, registerBufferRingIncSupported});
        }
        UNAVAILABILITY_CAUSE = cause;
        IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED = socketNonEmptySupported;
        IORING_SPLICE_SUPPORTED = spliceSupported;
        IORING_ACCEPT_NO_WAIT_SUPPORTED = acceptSupportNoWait;
        IORING_ACCEPT_MULTISHOT_SUPPORTED = acceptMultishotSupported;
        IORING_RECV_MULTISHOT_SUPPORTED = recvMultishotSupported;
        IORING_RECVSEND_BUNDLE_SUPPORTED = recvsendBundleSupported;
        IORING_POLL_ADD_MULTISHOT_SUPPORTED = pollAddMultishotSupported;
        IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED = registerIowqWorkersSupported;
        IORING_SETUP_SUBMIT_ALL_SUPPORTED = submitAllSupported;
        IORING_SETUP_CQ_SIZE_SUPPORTED = setUpCqSizeSupported;
        IORING_SETUP_SINGLE_ISSUER_SUPPORTED = singleIssuerSupported;
        IORING_SETUP_DEFER_TASKRUN_SUPPORTED = deferTaskrunSupported;
        IORING_REGISTER_BUFFER_RING_SUPPORTED = registerBufferRingSupported;
        IORING_REGISTER_BUFFER_RING_INC_SUPPORTED = registerBufferRingIncSupported;
    }
}

