/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.IoUringBufferRingConfig;
import io.netty.channel.uring.IoUringBufferRingHandler;
import io.netty.channel.uring.Native;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class IoUringIoHandlerConfig {
    private int ringSize = Native.DEFAULT_RING_SIZE;
    private int maxBoundedWorker;
    private int maxUnboundedWorker;
    private Set<IoUringBufferRingConfig> bufferRingConfigs;
    private IoUringBufferRingHandler bufferRingHandler;

    public int getRingSize() {
        return this.ringSize;
    }

    public int getMaxBoundedWorker() {
        return this.maxBoundedWorker;
    }

    public int getMaxUnboundedWorker() {
        return this.maxUnboundedWorker;
    }

    public IoUringIoHandlerConfig setRingSize(int ringSize) {
        this.ringSize = ObjectUtil.checkPositive((int)ringSize, (String)"ringSize");
        return this;
    }

    public IoUringIoHandlerConfig setMaxBoundedWorker(int maxBoundedWorker) {
        this.maxBoundedWorker = ObjectUtil.checkPositiveOrZero((int)maxBoundedWorker, (String)"maxBoundedWorker");
        return this;
    }

    public IoUringIoHandlerConfig setMaxUnboundedWorker(int maxUnboundedWorker) {
        this.maxUnboundedWorker = ObjectUtil.checkPositiveOrZero((int)maxUnboundedWorker, (String)"maxUnboundedWorker");
        return this;
    }

    public IoUringIoHandlerConfig setBufferRingConfig(IoUringBufferRingHandler bufferRingHandler, IoUringBufferRingConfig ... ringConfig) {
        Objects.requireNonNull(bufferRingHandler, "bufferRingHandler");
        HashSet<IoUringBufferRingConfig> configSet = new HashSet<IoUringBufferRingConfig>(ringConfig.length);
        for (IoUringBufferRingConfig bufferRingConfig : ringConfig) {
            if (configSet.add(bufferRingConfig)) continue;
            throw new IllegalArgumentException("Duplicated buffer group id: " + bufferRingConfig.bufferGroupId());
        }
        this.bufferRingHandler = bufferRingHandler;
        this.bufferRingConfigs = configSet;
        return this;
    }

    public List<IoUringBufferRingConfig> getBufferRingConfigs() {
        return new ArrayList<IoUringBufferRingConfig>(this.bufferRingConfigs);
    }

    boolean needRegisterIowqMaxWorker() {
        return this.maxBoundedWorker > 0 || this.maxUnboundedWorker > 0;
    }

    public IoUringBufferRingHandler getBufferRingHandler() {
        return this.bufferRingHandler;
    }

    Set<IoUringBufferRingConfig> getInternBufferRingConfigs() {
        return this.bufferRingConfigs;
    }
}

