/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.CompletionQueue;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.SubmissionQueue;

final class RingBuffer {
    private final SubmissionQueue ioUringSubmissionQueue;
    private final CompletionQueue ioUringCompletionQueue;
    private final int features;

    RingBuffer(SubmissionQueue ioUringSubmissionQueue, CompletionQueue ioUringCompletionQueue, int features) {
        this.ioUringSubmissionQueue = ioUringSubmissionQueue;
        this.ioUringCompletionQueue = ioUringCompletionQueue;
        this.features = features;
    }

    int fd() {
        return this.ioUringCompletionQueue.ringFd;
    }

    int features() {
        return this.features;
    }

    SubmissionQueue ioUringSubmissionQueue() {
        return this.ioUringSubmissionQueue;
    }

    CompletionQueue ioUringCompletionQueue() {
        return this.ioUringCompletionQueue;
    }

    void close() {
        this.ioUringSubmissionQueue.release();
        Native.ioUringExit(this.ioUringSubmissionQueue.submissionQueueArrayAddress, this.ioUringSubmissionQueue.ringEntries, this.ioUringSubmissionQueue.ringAddress, this.ioUringSubmissionQueue.ringSize, this.ioUringCompletionQueue.ringAddress, this.ioUringCompletionQueue.ringSize, this.ioUringCompletionQueue.ringFd);
    }
}

