/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.uring.IoUringChannelOption;
import java.util.Map;

abstract class IOUringChannelConfig
extends DefaultChannelConfig {
    private volatile boolean pollInFirst = true;
    private volatile boolean ioseqAsync;

    IOUringChannelConfig(Channel channel) {
        super(channel);
    }

    IOUringChannelConfig(Channel channel, RecvByteBufAllocator allocator) {
        super(channel, allocator);
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{IoUringChannelOption.POLLIN_FIRST, IoUringChannelOption.IOSQE_ASYNC});
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == IoUringChannelOption.POLLIN_FIRST) {
            return (T)Boolean.valueOf(this.pollInFirst);
        }
        if (option == IoUringChannelOption.IOSQE_ASYNC) {
            return (T)Boolean.valueOf(this.ioseqAsync);
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == IoUringChannelOption.POLLIN_FIRST) {
            this.setPollInFirst((Boolean)value);
        } else if (option == IoUringChannelOption.IOSQE_ASYNC) {
            this.setIoseqAsync((Boolean)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    boolean getPollInFirst() {
        return this.pollInFirst;
    }

    void setPollInFirst(boolean pollInFirst) {
        this.pollInFirst = pollInFirst;
    }

    boolean getIoseqAsync() {
        return this.ioseqAsync;
    }

    void setIoseqAsync(boolean ioseqAsync) {
        this.ioseqAsync = ioseqAsync;
    }

    public IOUringChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Deprecated
    public IOUringChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    public IOUringChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    public IOUringChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    public IOUringChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    public IOUringChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    public IOUringChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @Deprecated
    public IOUringChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Deprecated
    public IOUringChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    public IOUringChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public IOUringChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }
}

