/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Limits;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringFileRegion;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringIoRegistration;
import io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.Native;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;

abstract class AbstractIoUringStreamChannel
extends AbstractIoUringChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractIoUringStreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private byte writeOpCode;
    private long writeId;
    private long readId;

    AbstractIoUringStreamChannel(Channel parent, LinuxSocket socket, boolean active) {
        super(parent, socket, active);
    }

    AbstractIoUringStreamChannel(Channel parent, LinuxSocket socket, SocketAddress remote) {
        super(parent, socket, remote);
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected final AbstractIoUringChannel.AbstractUringUnsafe newUnsafe() {
        return new IoUringStreamUnsafe();
    }

    public final ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    public final ChannelFuture shutdown(final ChannelPromise promise) {
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            shutdownOutputFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    AbstractIoUringStreamChannel.this.shutdownOutputDone(shutdownOutputFuture, promise);
                }
            });
        }
        return promise;
    }

    protected final void doShutdownOutput() throws Exception {
        this.socket.shutdown(false, true);
    }

    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.socket.shutdown(true, false);
            promise.setSuccess();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    public final boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public final boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public final boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public final ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    public final ChannelFuture shutdownOutput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise);
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)AbstractIoUringStreamChannel.this.unsafe()).shutdownOutput(promise);
                }
            });
        }
        return promise;
    }

    public final ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    public final ChannelFuture shutdownInput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownInput0(promise);
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractIoUringStreamChannel.this.shutdownInput0(promise);
                }
            });
        }
        return promise;
    }

    private void shutdownOutputDone(final ChannelFuture shutdownOutputFuture, final ChannelPromise promise) {
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            AbstractIoUringStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
        } else {
            shutdownInputFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                    AbstractIoUringStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
                }
            });
        }
    }

    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            if (shutdownInputCause != null) {
                logger.info("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(shutdownOutputCause);
        } else if (shutdownInputCause != null) {
            promise.setFailure(shutdownInputCause);
        } else {
            promise.setSuccess();
        }
    }

    @Override
    protected final void doRegister(ChannelPromise promise) {
        super.doRegister(promise);
        promise.addListener(f -> {
            if (f.isSuccess() && this.active) {
                this.schedulePollRdHup();
            }
        });
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (IoUring.isIOUringSpliceSupported() && msg instanceof DefaultFileRegion) {
            return new IoUringFileRegion((DefaultFileRegion)msg);
        }
        return super.filterOutboundMessage(msg);
    }

    @Override
    protected final void cancelOutstandingReads(IoUringIoRegistration registration, int numOutstandingReads) {
        if (this.readId != 0L) {
            assert (numOutstandingReads == 1);
            int fd = this.fd().intValue();
            IoUringIoOps ops = IoUringIoOps.newAsyncCancel(fd, this.flags((byte)0), this.readId, (short)27);
            registration.submit(ops);
        } else assert (numOutstandingReads == 0);
    }

    @Override
    protected final void cancelOutstandingWrites(IoUringIoRegistration registration, int numOutstandingWrites) {
        if (this.writeId != 0L) {
            assert (numOutstandingWrites == 1);
            assert (this.writeOpCode != 0);
            int fd = this.fd().intValue();
            registration.submit(IoUringIoOps.newAsyncCancel(fd, this.flags((byte)0), this.writeId, this.writeOpCode));
        } else assert (numOutstandingWrites == 0);
    }

    @Override
    protected boolean socketIsEmpty(int flags) {
        return IoUring.isIOUringCqeFSockNonEmptySupported() && (flags & 4) == 0;
    }

    private final class IoUringStreamUnsafe
    extends AbstractIoUringChannel.AbstractUringUnsafe {
        private ByteBuf readBuffer;
        private IovArray iovArray;

        private IoUringStreamUnsafe() {
            super(AbstractIoUringStreamChannel.this);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            assert (this.iovArray == null);
            assert (AbstractIoUringStreamChannel.this.writeId == 0L);
            int numElements = Math.min(in.size(), Limits.IOV_MAX);
            ByteBuf iovArrayBuffer = AbstractIoUringStreamChannel.this.alloc().directBuffer(numElements * IovArray.IOV_SIZE);
            this.iovArray = new IovArray(iovArrayBuffer);
            try {
                int offset = this.iovArray.count();
                in.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)this.iovArray);
                int fd = AbstractIoUringStreamChannel.this.fd().intValue();
                IoUringIoRegistration registration = AbstractIoUringStreamChannel.this.registration();
                IoUringIoOps ops = IoUringIoOps.newWritev(fd, AbstractIoUringStreamChannel.this.flags((byte)0), 0, this.iovArray.memoryAddress(offset), this.iovArray.count() - offset, AbstractIoUringStreamChannel.this.nextOpsId());
                byte opCode = ops.opcode();
                AbstractIoUringStreamChannel.this.writeId = registration.submit(ops);
                AbstractIoUringStreamChannel.this.writeOpCode = opCode;
                if (AbstractIoUringStreamChannel.this.writeId == 0L) {
                    this.iovArray.release();
                    this.iovArray = null;
                    return 0;
                }
            }
            catch (Exception e) {
                this.iovArray.release();
                this.iovArray = null;
                this.scheduleWriteSingle(in.current());
            }
            return 1;
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            IoUringIoOps ops;
            assert (this.iovArray == null);
            assert (AbstractIoUringStreamChannel.this.writeId == 0L);
            int fd = AbstractIoUringStreamChannel.this.fd().intValue();
            IoUringIoRegistration registration = AbstractIoUringStreamChannel.this.registration();
            if (msg instanceof IoUringFileRegion) {
                IoUringFileRegion fileRegion = (IoUringFileRegion)msg;
                try {
                    fileRegion.open();
                }
                catch (IOException e) {
                    this.handleWriteError(e);
                    return 0;
                }
                ops = fileRegion.splice(fd);
            } else {
                ByteBuf buf = (ByteBuf)msg;
                ops = IoUringIoOps.newWrite(fd, AbstractIoUringStreamChannel.this.flags((byte)0), 0, buf.memoryAddress() + (long)buf.readerIndex(), buf.readableBytes(), AbstractIoUringStreamChannel.this.nextOpsId());
            }
            byte opCode = ops.opcode();
            AbstractIoUringStreamChannel.this.writeId = registration.submit(ops);
            AbstractIoUringStreamChannel.this.writeOpCode = opCode;
            if (AbstractIoUringStreamChannel.this.writeId == 0L) {
                return 0;
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int scheduleRead0(boolean first, boolean socketIsEmpty) {
            assert (this.readBuffer == null);
            assert (AbstractIoUringStreamChannel.this.readId == 0L);
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ByteBuf byteBuf = allocHandle.allocate(AbstractIoUringStreamChannel.this.alloc());
            try {
                int recvFlags;
                short ioPrio;
                allocHandle.attemptedBytesRead(byteBuf.writableBytes());
                int fd = AbstractIoUringStreamChannel.this.fd().intValue();
                IoUringIoRegistration registration = AbstractIoUringStreamChannel.this.registration();
                if (first) {
                    ioPrio = socketIsEmpty && IoUring.isIOUringCqeFSockNonEmptySupported() ? (short)1 : 0;
                    recvFlags = 0;
                } else {
                    ioPrio = 0;
                    recvFlags = Native.MSG_DONTWAIT;
                }
                IoUringIoOps ops = IoUringIoOps.newRecv(fd, AbstractIoUringStreamChannel.this.flags((byte)0), ioPrio, recvFlags, byteBuf.memoryAddress() + (long)byteBuf.writerIndex(), byteBuf.writableBytes(), AbstractIoUringStreamChannel.this.nextOpsId());
                AbstractIoUringStreamChannel.this.readId = registration.submit(ops);
                if (AbstractIoUringStreamChannel.this.readId == 0L) {
                    int n = 0;
                    return n;
                }
                this.readBuffer = byteBuf;
                byteBuf = null;
                int n = 1;
                return n;
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }

        @Override
        protected void readComplete0(byte op, int res, int flags, short data, int outstanding) {
            assert (AbstractIoUringStreamChannel.this.readId != 0L);
            AbstractIoUringStreamChannel.this.readId = 0L;
            boolean allDataRead = false;
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = AbstractIoUringStreamChannel.this.pipeline();
            ByteBuf byteBuf = this.readBuffer;
            this.readBuffer = null;
            assert (byteBuf != null);
            try {
                if (res < 0) {
                    if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                        byteBuf.release();
                        return;
                    }
                    allocHandle.lastBytesRead(Errors.ioResult((String)"io_uring read", (int)res));
                } else if (res > 0) {
                    byteBuf.writerIndex(byteBuf.writerIndex() + res);
                    allocHandle.lastBytesRead(res);
                } else {
                    allocHandle.lastBytesRead(-1);
                }
                if (allocHandle.lastBytesRead() <= 0) {
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl = allDataRead = allocHandle.lastBytesRead() < 0;
                    if (allDataRead) {
                        this.shutdownInput(true);
                    }
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    return;
                }
                allocHandle.incMessagesRead(1);
                pipeline.fireChannelRead((Object)byteBuf);
                byteBuf = null;
                if (allocHandle.continueReading() && !AbstractIoUringStreamChannel.this.socketIsEmpty(flags)) {
                    this.scheduleRead(false);
                } else {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, allDataRead, allocHandle);
            }
        }

        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean allDataRead, IoUringRecvByteAllocatorHandle allocHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (allDataRead || cause instanceof IOException) {
                this.shutdownInput(true);
            }
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            assert (AbstractIoUringStreamChannel.this.writeId != 0L);
            AbstractIoUringStreamChannel.this.writeId = 0L;
            AbstractIoUringStreamChannel.this.writeOpCode = (byte)0;
            ChannelOutboundBuffer channelOutboundBuffer = AbstractIoUringStreamChannel.this.unsafe().outboundBuffer();
            Object current = channelOutboundBuffer.current();
            if (current instanceof IoUringFileRegion) {
                IoUringFileRegion fileRegion = (IoUringFileRegion)current;
                try {
                    int result;
                    int n = result = res >= 0 ? res : Errors.ioResult((String)"io_uring splice", (int)res);
                    if (result == 0 && fileRegion.count() > 0L) {
                        AbstractIoUringStreamChannel.this.validateFileRegion(fileRegion.fileRegion, fileRegion.transfered());
                        return false;
                    }
                    int progress = fileRegion.handleResult(result, data);
                    if (progress == -1) {
                        channelOutboundBuffer.remove();
                    } else if (progress > 0) {
                        channelOutboundBuffer.progress((long)progress);
                    }
                }
                catch (Throwable cause) {
                    this.handleWriteError(cause);
                }
                return true;
            }
            IovArray iovArray = this.iovArray;
            if (iovArray != null) {
                this.iovArray = null;
                iovArray.release();
            }
            if (res >= 0) {
                channelOutboundBuffer.removeBytes((long)res);
            } else {
                if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                    return true;
                }
                try {
                    if (Errors.ioResult((String)"io_uring write", (int)res) == 0) {
                        return false;
                    }
                }
                catch (Throwable cause) {
                    this.handleWriteError(cause);
                }
            }
            return true;
        }

        @Override
        protected void freeResourcesNow(IoUringIoRegistration reg) {
            super.freeResourcesNow(reg);
            assert (this.readBuffer == null);
        }
    }
}

