/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.IoEventLoop;
import io.netty.channel.IoExecutionContext;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.uring.CompletionCallback;
import io.netty.channel.uring.CompletionQueue;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoEvent;
import io.netty.channel.uring.IoUringIoHandle;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringIoRegistration;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.RingBuffer;
import io.netty.channel.uring.SubmissionQueue;
import io.netty.channel.uring.UserData;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class IoUringIoHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IoUringIoHandler.class);
    private static final short RING_CLOSE = 1;
    private final RingBuffer ringBuffer;
    private final IntObjectMap<DefaultIoUringIoRegistration> registrations;
    private final byte[] inet4AddressArray = new byte[4];
    private final byte[] inet6AddressArray = new byte[16];
    private final AtomicBoolean eventfdAsyncNotify = new AtomicBoolean();
    private final FileDescriptor eventfd;
    private final long eventfdReadBuf;
    private long eventfdReadSubmitted;
    private boolean eventFdClosing;
    private volatile boolean shuttingDown;
    private boolean closeCompleted;
    private int nextRegistrationId = Integer.MIN_VALUE;
    private static final int EVENTFD_ID = Integer.MAX_VALUE;
    private static final int RINGFD_ID = 0x7FFFFFFE;
    private static final int INVALID_ID = 0;

    IoUringIoHandler(RingBuffer ringBuffer) {
        IoUring.ensureAvailability();
        this.ringBuffer = Objects.requireNonNull(ringBuffer, "ringBuffer");
        this.registrations = new IntObjectHashMap();
        this.eventfd = Native.newBlockingEventFd();
        this.eventfdReadBuf = PlatformDependent.allocateMemory((long)8L);
    }

    public int run(IoExecutionContext context) {
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        if (!completionQueue.hasCompletions() && context.canBlock()) {
            if (this.eventfdReadSubmitted == 0L) {
                this.submitEventFdRead();
            }
            if (context.deadlineNanos() != -1L) {
                this.submitTimeout(context);
            }
            submissionQueue.submitAndWait();
        } else {
            submissionQueue.submit();
        }
        return completionQueue.process(this::handle);
    }

    private void handle(int res, int flags, int id, byte op, short data) {
        if (id == Integer.MAX_VALUE) {
            this.handleEventFdRead();
            return;
        }
        if (id == 0x7FFFFFFE) {
            if (op == 0 && data == 1) {
                this.completeRingClose();
            }
            return;
        }
        DefaultIoUringIoRegistration registration = (DefaultIoUringIoRegistration)this.registrations.get(id);
        if (registration == null) {
            logger.debug("ignoring {} completion for unknown registration (id={}, res={})", new Object[]{Native.opToStr(op), id, res});
            return;
        }
        registration.handle(res, flags, op, data);
    }

    private void handleEventFdRead() {
        this.eventfdReadSubmitted = 0L;
        if (!this.eventFdClosing) {
            this.eventfdAsyncNotify.set(false);
            this.submitEventFdRead();
        }
    }

    private void submitEventFdRead() {
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        this.eventfdReadSubmitted = submissionQueue.addEventFdRead(this.eventfd.intValue(), this.eventfdReadBuf, 0, 8, Integer.MAX_VALUE, (short)0);
    }

    private void submitTimeout(IoExecutionContext context) {
        long delayNanos = context.delayNanos(System.nanoTime());
        this.ringBuffer.ioUringSubmissionQueue().addTimeout(this.ringBuffer.fd(), delayNanos, 0x7FFFFFFE, (short)0);
    }

    public void prepareToDestroy() {
        this.shuttingDown = true;
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        ArrayList copy = new ArrayList(this.registrations.values());
        for (DefaultIoUringIoRegistration registration : copy) {
            registration.close();
        }
        submissionQueue.addNop(this.ringBuffer.fd(), (byte)Native.IOSQE_IO_DRAIN, 0x7FFFFFFE, (short)0);
        submissionQueue.submit();
        while (completionQueue.hasCompletions()) {
            completionQueue.process(this::handle);
            if (submissionQueue.count() <= 0) continue;
            submissionQueue.submit();
        }
    }

    public void destroy() {
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        this.drainEventFd();
        if (submissionQueue.remaining() < 2) {
            submissionQueue.submit();
        }
        submissionQueue.addNop(this.ringBuffer.fd(), (byte)Native.IOSQE_IO_DRAIN, 0x7FFFFFFE, (short)0);
        submissionQueue.addLinkTimeout(this.ringBuffer.fd(), TimeUnit.MILLISECONDS.toNanos(200L), 0x7FFFFFFE, (short)0);
        submissionQueue.submitAndWait();
        completionQueue.process(this::handle);
        this.completeRingClose();
    }

    private void drainEventFd() {
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        assert (!this.eventFdClosing);
        this.eventFdClosing = true;
        boolean eventPending = this.eventfdAsyncNotify.getAndSet(true);
        if (eventPending) {
            while (this.eventfdReadSubmitted == 0L) {
                this.submitEventFdRead();
                submissionQueue.submit();
            }
            class DrainFdEventCallback
            implements CompletionCallback {
                boolean eventFdDrained;

                DrainFdEventCallback() {
                }

                @Override
                public void handle(int res, int flags, int id, byte op, short data) {
                    if (id == Integer.MAX_VALUE) {
                        this.eventFdDrained = true;
                    }
                    IoUringIoHandler.this.handle(res, flags, id, op, data);
                }
            }
            DrainFdEventCallback handler = new DrainFdEventCallback();
            completionQueue.process(handler);
            while (!handler.eventFdDrained) {
                submissionQueue.submitAndWait();
                completionQueue.process(handler);
            }
        }
        if (this.eventfdReadSubmitted != 0L) {
            submissionQueue.addCancel(this.eventfd.intValue(), this.eventfdReadSubmitted, Integer.MAX_VALUE);
            this.eventfdReadSubmitted = 0L;
            submissionQueue.submit();
        }
    }

    private void completeRingClose() {
        if (this.closeCompleted) {
            return;
        }
        this.closeCompleted = true;
        this.ringBuffer.close();
        try {
            this.eventfd.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close eventfd", (Throwable)e);
        }
        PlatformDependent.freeMemory((long)this.eventfdReadBuf);
    }

    public IoRegistration register(IoEventLoop eventLoop, IoHandle handle) throws Exception {
        int id;
        DefaultIoUringIoRegistration old;
        IoUringIoHandle ioHandle = IoUringIoHandler.cast(handle);
        if (this.shuttingDown) {
            throw new RejectedExecutionException("IoEventLoop is shutting down");
        }
        DefaultIoUringIoRegistration registration = new DefaultIoUringIoRegistration(eventLoop, ioHandle);
        while ((old = (DefaultIoUringIoRegistration)this.registrations.put(id = this.nextRegistrationId(), (Object)registration)) != null) {
            assert (old.handle != registration.handle);
            this.registrations.put(id, (Object)old);
        }
        registration.setId(id);
        this.ringBuffer.ioUringSubmissionQueue().incrementHandledFds();
        return registration;
    }

    private int nextRegistrationId() {
        int id;
        do {
            ++this.nextRegistrationId;
        } while (id == 0x7FFFFFFE || id == Integer.MAX_VALUE || id == 0);
        return id;
    }

    private static IoUringIoHandle cast(IoHandle handle) {
        if (handle instanceof IoUringIoHandle) {
            return (IoUringIoHandle)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName((Object)handle) + " not supported");
    }

    public void wakeup(IoEventLoop eventLoop) {
        if (!eventLoop.inEventLoop() && !this.eventfdAsyncNotify.getAndSet(true)) {
            Native.eventFdWrite(this.eventfd.intValue(), 1L);
        }
    }

    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return IoUringIoHandle.class.isAssignableFrom(handleType);
    }

    byte[] inet4AddressArray() {
        return this.inet4AddressArray;
    }

    byte[] inet6AddressArray() {
        return this.inet6AddressArray;
    }

    public static IoHandlerFactory newFactory() {
        IoUring.ensureAvailability();
        return () -> new IoUringIoHandler(Native.createRingBuffer());
    }

    public static IoHandlerFactory newFactory(int ringSize) {
        IoUring.ensureAvailability();
        ObjectUtil.checkPositive((int)ringSize, (String)"ringSize");
        return () -> new IoUringIoHandler(Native.createRingBuffer(ringSize));
    }

    private final class DefaultIoUringIoRegistration
    implements IoUringIoRegistration {
        private final Promise<?> cancellationPromise;
        private final IoEventLoop eventLoop;
        private final IoUringIoEvent event = new IoUringIoEvent(0, 0, 0, 0);
        final IoUringIoHandle handle;
        private boolean removeLater;
        private int outstandingCompletions;
        private int id;

        DefaultIoUringIoRegistration(IoEventLoop eventLoop, IoUringIoHandle handle) {
            this.eventLoop = eventLoop;
            this.handle = handle;
            this.cancellationPromise = eventLoop.newPromise();
        }

        void setId(int id) {
            this.id = id;
        }

        @Override
        public long submit(IoOps ops) {
            IoUringIoOps ioOps = (IoUringIoOps)ops;
            if (!this.isValid()) {
                return 0L;
            }
            long udata = UserData.encode(this.id, ioOps.opcode(), ioOps.data());
            if (this.eventLoop.inEventLoop()) {
                this.submit0(ioOps, udata);
            } else {
                this.eventLoop.execute(() -> this.submit0(ioOps, udata));
            }
            return udata;
        }

        private void submit0(IoUringIoOps ioOps, long udata) {
            IoUringIoHandler.this.ringBuffer.ioUringSubmissionQueue().enqueueSqe(ioOps.opcode(), ioOps.flags(), ioOps.ioPrio(), ioOps.fd(), ioOps.union1(), ioOps.union2(), ioOps.len(), ioOps.union3(), udata, ioOps.union4(), ioOps.personality(), ioOps.union5(), ioOps.union6());
            ++this.outstandingCompletions;
        }

        public IoUringIoHandler ioHandler() {
            return IoUringIoHandler.this;
        }

        @Override
        public void cancel() {
            if (!this.cancellationPromise.trySuccess(null)) {
                return;
            }
            if (this.eventLoop.inEventLoop()) {
                this.tryRemove();
            } else {
                this.eventLoop.execute(this::tryRemove);
            }
        }

        public Future<?> cancelFuture() {
            return this.cancellationPromise;
        }

        private void tryRemove() {
            if (this.outstandingCompletions > 0) {
                this.removeLater = true;
                return;
            }
            this.remove();
        }

        private void remove() {
            DefaultIoUringIoRegistration old = (DefaultIoUringIoRegistration)IoUringIoHandler.this.registrations.remove(this.id);
            assert (old == this);
            IoUringIoHandler.this.ringBuffer.ioUringSubmissionQueue().decrementHandledFds();
        }

        void close() {
            assert (this.eventLoop.inEventLoop());
            try {
                this.handle.close();
            }
            catch (Exception e) {
                logger.debug("Exception during closing " + this.handle, (Throwable)e);
            }
        }

        void handle(int res, int flags, byte op, short data) {
            this.event.update(res, flags, op, data);
            this.handle.handle(this, this.event);
            if (--this.outstandingCompletions == 0 && this.removeLater) {
                this.removeLater = false;
                this.remove();
            }
        }
    }
}

