/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.IoOps;
import io.netty.channel.uring.Native;

public final class IoUringIoOps
implements IoOps {
    private final byte opcode;
    private final int flags;
    private final short ioPrio;
    private final int fd;
    private final int rwFlags;
    private final long bufferAddress;
    private final int length;
    private final long offset;
    private final short data;

    public IoUringIoOps(byte opcode, int flags, short ioPrio, int fd, int rwFlags, long bufferAddress, int length, long offset, short data) {
        this.opcode = opcode;
        this.flags = flags;
        this.ioPrio = ioPrio;
        this.fd = fd;
        this.rwFlags = rwFlags;
        this.bufferAddress = bufferAddress;
        this.length = length;
        this.offset = offset;
        this.data = data;
    }

    public int fd() {
        return this.fd;
    }

    public byte opcode() {
        return this.opcode;
    }

    public int flags() {
        return this.flags;
    }

    public short ioPrio() {
        return this.ioPrio;
    }

    public int rwFlags() {
        return this.rwFlags;
    }

    public long bufferAddress() {
        return this.bufferAddress;
    }

    public int length() {
        return this.length;
    }

    public long offset() {
        return this.offset;
    }

    public short data() {
        return this.data;
    }

    public String toString() {
        return "IOUringIoOps{opcode=" + this.opcode + ", flags=" + this.flags + ", ioPrio=" + this.ioPrio + ", fd=" + this.fd + ", rwFlags=" + this.rwFlags + ", bufferAddress=" + this.bufferAddress + ", length=" + this.length + ", offset=" + this.offset + ", data=" + this.data + '}';
    }

    public static IoUringIoOps newAsyncCancel(int fd, int flags, long userData, short data) {
        return new IoUringIoOps(14, flags, 0, fd, 0, userData, 0, 0L, data);
    }

    public static IoUringIoOps newClose(int fd, int flags, short data) {
        return new IoUringIoOps(19, flags, 0, fd, 0, 0L, 0, 0L, data);
    }

    public static IoUringIoOps newPollAdd(int fd, int flags, int mask, short data) {
        return new IoUringIoOps(6, flags, 0, fd, mask, 0L, 0, 0L, data);
    }

    public static IoUringIoOps newSendmsg(int fd, int flags, int msgFlags, long address, short data) {
        return new IoUringIoOps(9, flags, 0, fd, msgFlags, address, 1, 0L, data);
    }

    public static IoUringIoOps newConnect(int fd, int flags, long remoteMemoryAddress, short data) {
        return new IoUringIoOps(16, flags, 0, fd, 0, remoteMemoryAddress, 0, Native.SIZEOF_SOCKADDR_STORAGE, data);
    }

    public static IoUringIoOps newPollRemove(int fd, int flags, long userData, short data) {
        return new IoUringIoOps(7, flags, 0, fd, 0, userData, 0, 0L, data);
    }

    public static IoUringIoOps newAccept(int fd, int flags, int acceptFlags, long acceptedAddressMemoryAddress, long acceptedAddressLengthMemoryAddress, short data) {
        return new IoUringIoOps(13, flags, 0, fd, acceptFlags, acceptedAddressMemoryAddress, 0, acceptedAddressLengthMemoryAddress, data);
    }

    public static IoUringIoOps newWritev(int fd, int flags, int writevFlags, long memoryAddress, int length, short data) {
        return new IoUringIoOps(2, flags, 0, fd, writevFlags, memoryAddress, length, 0L, data);
    }

    public static IoUringIoOps newWrite(int fd, int flags, int writeFlags, long memoryAddress, int length, short data) {
        return new IoUringIoOps(23, flags, 0, fd, writeFlags, memoryAddress, length, 0L, data);
    }

    public static IoUringIoOps newRecv(int fd, int flags, int recvFlags, long memoryAddress, int length, short data) {
        return new IoUringIoOps(27, flags, 0, fd, recvFlags, memoryAddress, length, 0L, data);
    }

    public static IoUringIoOps newRecvmsg(int fd, int flags, int msgFlags, long memoryAddress, short data) {
        return new IoUringIoOps(10, flags, 0, fd, msgFlags, memoryAddress, 1, 0L, data);
    }

    public static IoUringIoOps newSend(int fd, int flags, int sendFlags, long memoryAddress, int length, short data) {
        return new IoUringIoOps(26, flags, 0, fd, sendFlags, memoryAddress, length, 0L, data);
    }

    public static IoUringIoOps newShutdown(int fd, int flags, int how, int id, short data) {
        return new IoUringIoOps(34, flags, 0, fd, 0, 0L, how, 0L, data);
    }
}

