/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.CompletionCallback;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.UserData;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.StringJoiner;
import java.util.function.IntSupplier;

final class CompletionQueue
implements IntSupplier {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CompletionQueue.class);
    private static final int CQE_USER_DATA_FIELD = 0;
    private static final int CQE_RES_FIELD = 8;
    private static final int CQE_FLAGS_FIELD = 12;
    private static final long CQE_SIZE = 16L;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long completionQueueArrayAddress;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    private final int ringEntries;
    private final int ringMask;
    private int ringHead;

    CompletionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kOverflowAddress, long completionQueueArrayAddress, int ringSize, long ringAddress, int ringFd) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.completionQueueArrayAddress = completionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringEntries = PlatformDependent.getIntVolatile((long)kRingEntriesAddress);
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.ringHead = PlatformDependent.getIntVolatile((long)kHeadAddress);
    }

    boolean hasCompletions() {
        return this.ringHead != PlatformDependent.getIntVolatile((long)this.kTailAddress);
    }

    @Override
    public int getAsInt() {
        return this.count();
    }

    int count() {
        return PlatformDependent.getIntVolatile((long)this.kTailAddress) - this.ringHead;
    }

    int process(CompletionCallback callback) {
        int tail = PlatformDependent.getIntVolatile((long)this.kTailAddress);
        int i = 0;
        boolean isTraceEnabled = logger.isTraceEnabled();
        while (this.ringHead != tail) {
            long cqeAddress = this.completionQueueArrayAddress + (long)(this.ringHead & this.ringMask) * 16L;
            long udata = PlatformDependent.getLong((long)(cqeAddress + 0L));
            int res = PlatformDependent.getInt((long)(cqeAddress + 8L));
            int flags = PlatformDependent.getInt((long)(cqeAddress + 12L));
            ++this.ringHead;
            PlatformDependent.putIntOrdered((long)this.kHeadAddress, (int)this.ringHead);
            ++i;
            if (isTraceEnabled) {
                logger.trace("completed(ring {}): {}(id={}, res={})", new Object[]{this.ringFd, Native.opToStr(UserData.decodeOp(udata)), UserData.decodeId(udata), res});
            }
            try {
                UserData.decode(res, flags, udata, callback);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable throwable) {
                CompletionQueue.handleLoopException(throwable);
            }
        }
        return i;
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the IO event loop.", throwable);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "CompletionQueue [", "]");
        int tail = PlatformDependent.getIntVolatile((long)this.kTailAddress);
        for (int head = this.ringHead; head != tail; ++head) {
            long cqeAddress = this.completionQueueArrayAddress + (long)(this.ringHead & this.ringMask) * 16L;
            long udata = PlatformDependent.getLong((long)(cqeAddress + 0L));
            int res = PlatformDependent.getInt((long)(cqeAddress + 8L));
            sb.add(Native.opToStr(UserData.decodeOp(udata)) + "(id=" + UserData.decodeId(udata) + ",res=" + res + ')');
        }
        return sb.toString();
    }

    void ioUringWaitCqe() {
        int ret = Native.ioUringEnter(this.ringFd, 0, 1, Native.IORING_ENTER_GETEVENTS);
        if (logger.isTraceEnabled()) {
            logger.trace("completed(ring {}): {}", (Object)this.ringFd, (Object)this);
        }
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
    }
}

