/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.testsuite.transport.AbstractTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class DatagramConnectedWriteExceptionTest
extends AbstractClientSocketTest {
    @Override
    protected List<TestsuitePermutation.BootstrapFactory<Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagramSocket();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    @DisabledOnOs(value={OS.WINDOWS})
    public void testWriteThrowsPortUnreachableException(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) throws Throwable {
                DatagramConnectedWriteExceptionTest.this.testWriteExceptionAfterServerStop(bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testWriteExceptionAfterServerStop(Bootstrap clientBootstrap) throws Throwable {
        final CountDownLatch serverReceivedLatch = new CountDownLatch(1);
        Bootstrap serverBootstrap = (Bootstrap)((Bootstrap)clientBootstrap.clone().option(ChannelOption.SO_BROADCAST, (Object)false)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
                serverReceivedLatch.countDown();
            }
        });
        Channel serverChannel = serverBootstrap.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).sync().channel();
        InetSocketAddress serverAddress = (InetSocketAddress)serverChannel.localAddress();
        ((Bootstrap)clientBootstrap.option(ChannelOption.AUTO_READ, (Object)false)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
            }
        });
        Channel clientChannel = clientBootstrap.connect((SocketAddress)serverAddress).sync().channel();
        final CountDownLatch clientFirstSendLatch = new CountDownLatch(1);
        try {
            ByteBuf firstMessage = Unpooled.wrappedBuffer((byte[])"First message".getBytes(CharsetUtil.UTF_8));
            clientChannel.writeAndFlush((Object)firstMessage).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        clientFirstSendLatch.countDown();
                    }
                }
            });
            Assertions.assertTrue((boolean)serverReceivedLatch.await(5L, TimeUnit.SECONDS), (String)"Server should receive first message");
            Assertions.assertTrue((boolean)clientFirstSendLatch.await(5L, TimeUnit.SECONDS), (String)"Client should send first message");
            serverChannel.close().sync();
            final AtomicReference writeException = new AtomicReference();
            final CountDownLatch writesCompleteLatch = new CountDownLatch(10);
            for (int i = 0; i < 10; ++i) {
                ByteBuf message = Unpooled.wrappedBuffer((byte[])("Message " + i).getBytes(CharsetUtil.UTF_8));
                clientChannel.writeAndFlush((Object)message).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess()) {
                            writeException.compareAndSet(null, future.cause());
                        }
                        writesCompleteLatch.countDown();
                    }
                });
                Thread.sleep(50L);
            }
            Assertions.assertTrue((boolean)writesCompleteLatch.await(5L, TimeUnit.SECONDS), (String)"All writes should complete");
            Assertions.assertNotNull(writeException.get(), (String)"Should have captured a write exception");
            Assertions.assertInstanceOf(PortUnreachableException.class, writeException.get(), (String)("Expected PortUnreachableException but got: " + ((Throwable)writeException.get()).getClass().getName()));
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
        }
    }
}

