/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.UncheckedBooleanSupplier;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketReadPendingTest
extends AbstractSocketTest {
    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testReadPendingIsResetAfterEachRead(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketReadPendingTest.this.testReadPendingIsResetAfterEachRead(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadPendingIsResetAfterEachRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            ReadPendingInitializer serverInitializer = new ReadPendingInitializer();
            ReadPendingInitializer clientInitializer = new ReadPendingInitializer();
            ((ServerBootstrap)((ServerBootstrap)sb.option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.AUTO_READ, (Object)true)).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new TestNumReadsRecvByteBufAllocator(2)).childHandler((ChannelHandler)serverInitializer);
            serverChannel = sb.bind().syncUninterruptibly().channel();
            ((Bootstrap)((Bootstrap)cb.option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new TestNumReadsRecvByteBufAllocator(2))).handler((ChannelHandler)clientInitializer);
            clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            clientChannel.writeAndFlush((Object)TestsuitePermutation.randomBufferType(clientChannel.alloc(), new byte[4], 0, 4));
            Assertions.assertTrue((boolean)serverInitializer.channelInitLatch.await(5L, TimeUnit.SECONDS));
            serverInitializer.channel.writeAndFlush((Object)TestsuitePermutation.randomBufferType(serverInitializer.channel.alloc(), new byte[4], 0, 4));
            serverInitializer.channel.read();
            serverInitializer.readPendingHandler.assertAllRead();
            clientChannel.read();
            clientInitializer.readPendingHandler.assertAllRead();
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
        }
    }

    private static final class TestNumReadsRecvByteBufAllocator
    implements RecvByteBufAllocator {
        private final int numReads;

        TestNumReadsRecvByteBufAllocator(int numReads) {
            this.numReads = numReads;
        }

        public RecvByteBufAllocator.ExtendedHandle newHandle() {
            return new RecvByteBufAllocator.ExtendedHandle(){
                private int attemptedBytesRead;
                private int lastBytesRead;
                private int numMessagesRead;

                public ByteBuf allocate(ByteBufAllocator alloc) {
                    return alloc.ioBuffer(this.guess(), this.guess());
                }

                public int guess() {
                    return 1;
                }

                public void reset(ChannelConfig config) {
                    this.numMessagesRead = 0;
                }

                public void incMessagesRead(int numMessages) {
                    this.numMessagesRead += numMessages;
                }

                public void lastBytesRead(int bytes) {
                    this.lastBytesRead = bytes;
                }

                public int lastBytesRead() {
                    return this.lastBytesRead;
                }

                public void attemptedBytesRead(int bytes) {
                    this.attemptedBytesRead = bytes;
                }

                public int attemptedBytesRead() {
                    return this.attemptedBytesRead;
                }

                public boolean continueReading() {
                    return this.numMessagesRead < TestNumReadsRecvByteBufAllocator.this.numReads;
                }

                public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
                    return this.continueReading();
                }

                public void readComplete() {
                }
            };
        }
    }

    private static final class ReadPendingReadHandler
    extends ChannelInboundHandlerAdapter {
        private final AtomicInteger count = new AtomicInteger();
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CountDownLatch latch2 = new CountDownLatch(2);

        private ReadPendingReadHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ReferenceCountUtil.release((Object)msg);
            if (this.count.incrementAndGet() == 1) {
                ctx.read();
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            this.latch.countDown();
            this.latch2.countDown();
        }

        void assertAllRead() throws InterruptedException {
            Assertions.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)this.latch2.await(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)2, (int)this.count.get());
        }
    }

    private static class ReadPendingInitializer
    extends ChannelInitializer<Channel> {
        final ReadPendingReadHandler readPendingHandler = new ReadPendingReadHandler();
        final CountDownLatch channelInitLatch = new CountDownLatch(1);
        volatile Channel channel;

        private ReadPendingInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            this.channel = ch;
            ch.pipeline().addLast(new ChannelHandler[]{this.readPendingHandler});
            this.channelInitLatch.countDown();
        }
    }
}

