/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketConnectionAttemptTest;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class SocketTestPermutation {
    static final String BAD_HOST = SystemPropertyUtil.get((String)"io.netty.testsuite.badHost", (String)"198.51.100.254");
    static final int BAD_PORT = SystemPropertyUtil.getInt((String)"io.netty.testsuite.badPort", (int)65535);
    static final boolean INCLUDE_OIO = SystemPropertyUtil.getBoolean((String)"io.netty.testsuite.includeOio", (boolean)false);
    public static final int UNASSIGNED_PORT = 4;
    static final SocketTestPermutation INSTANCE;
    protected static final int NUM_THREADS = 4;
    protected static final int OIO_SO_TIMEOUT = 10;
    protected final EventLoopGroup NIO_GROUP = new NioEventLoopGroup(4, (ThreadFactory)new DefaultThreadFactory("testsuite-nio", true));
    protected final EventLoopGroup OIO_GROUP = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio", true));

    protected <A extends AbstractBootstrap<?, ?>, B extends AbstractBootstrap<?, ?>> List<TestsuitePermutation.BootstrapComboFactory<A, B>> combo(List<TestsuitePermutation.BootstrapFactory<A>> sbfs, List<TestsuitePermutation.BootstrapFactory<B>> cbfs) {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<A, B>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<A, B>>();
        for (TestsuitePermutation.BootstrapFactory<A> sbf : sbfs) {
            for (TestsuitePermutation.BootstrapFactory<B> cbf : cbfs) {
                final TestsuitePermutation.BootstrapFactory<A> sbf0 = sbf;
                final TestsuitePermutation.BootstrapFactory<B> cbf0 = cbf;
                list.add(new TestsuitePermutation.BootstrapComboFactory<A, B>(){

                    @Override
                    public A newServerInstance() {
                        return sbf0.newInstance();
                    }

                    @Override
                    public B newClientInstance() {
                        return cbf0.newInstance();
                    }
                });
            }
        }
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List sbfs = this.serverSocket();
        List cbfs = this.clientSocket();
        List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = this.combo(sbfs, cbfs);
        if (INCLUDE_OIO) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socketWithFastOpen() {
        List sbfs = this.serverSocket();
        List cbfs = this.clientSocketWithFastOpen();
        List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = this.combo(sbfs, cbfs);
        if (INCLUDE_OIO) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram(final InternetProtocolFamily family) {
        ArrayList bfs = new ArrayList();
        bfs.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.NIO_GROUP)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(family);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        });
        if (INCLUDE_OIO) {
            bfs.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

                @Override
                public Bootstrap newInstance() {
                    return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.OIO_GROUP)).channel(OioDatagramChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
                }
            });
        }
        return this.combo(bfs, bfs);
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> factories = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        factories.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(SocketTestPermutation.this.NIO_GROUP).channel(NioServerSocketChannel.class);
            }
        });
        if (INCLUDE_OIO) {
            factories.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

                @Override
                public ServerBootstrap newInstance() {
                    return (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(SocketTestPermutation.this.OIO_GROUP).channel(OioServerSocketChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
                }
            });
        }
        return factories;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> factories = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        factories.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.NIO_GROUP)).channel(NioSocketChannel.class);
            }
        });
        if (INCLUDE_OIO) {
            factories.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

                @Override
                public Bootstrap newInstance() {
                    return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.OIO_GROUP)).channel(OioSocketChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
                }
            });
        }
        return factories;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocketWithFastOpen() {
        return this.clientSocket();
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> datagramSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> factories = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        factories.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.NIO_GROUP)).channel(NioDatagramChannel.class);
            }
        });
        if (INCLUDE_OIO) {
            factories.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

                @Override
                public Bootstrap newInstance() {
                    return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.OIO_GROUP)).channel(OioDatagramChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
                }
            });
        }
        return factories;
    }

    static {
        InternalLogger logger = InternalLoggerFactory.getInstance(SocketConnectionAttemptTest.class);
        logger.debug("-Dio.netty.testsuite.badHost: {}", (Object)BAD_HOST);
        logger.debug("-Dio.netty.testsuite.badPort: {}", (Object)BAD_PORT);
        INSTANCE = new SocketTestPermutation();
    }
}

