/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import org.junit.jupiter.api.TestInfo;

public abstract class AbstractTestsuiteTest<T extends AbstractBootstrap<?, ?>> {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    protected volatile T cb;

    protected abstract List<TestsuitePermutation.BootstrapFactory<T>> newFactories();

    protected List<ByteBufAllocator> newAllocators() {
        return TestsuitePermutation.allocator();
    }

    protected void run(TestInfo testInfo, Runner<T> runner) throws Throwable {
        List<TestsuitePermutation.BootstrapFactory<T>> combos = this.newFactories();
        String methodName = TestUtils.testMethodName(testInfo);
        for (ByteBufAllocator allocator : this.newAllocators()) {
            int i = 0;
            for (TestsuitePermutation.BootstrapFactory<T> e : combos) {
                this.cb = e.newInstance();
                this.configure(this.cb, allocator);
                this.logger.info(String.format("Running: %s %d of %d with %s", methodName, ++i, combos.size(), StringUtil.simpleClassName((Object)allocator)));
                runner.run(this.cb);
            }
        }
    }

    protected abstract void configure(T var1, ByteBufAllocator var2);

    public static interface Runner<CB extends AbstractBootstrap<?, ?>> {
        public void run(CB var1) throws Throwable;
    }
}

