/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class NameResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NameResolverGroup.class);
    private final Map<EventExecutor, NameResolver<T>> resolvers = new IdentityHashMap<EventExecutor, NameResolver<T>>();

    protected NameResolverGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameResolver<T> getResolver(final EventExecutor executor) {
        NameResolver<T> r;
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (executor.isShuttingDown()) {
            throw new IllegalStateException("executor not accepting a task");
        }
        Map<EventExecutor, NameResolver<T>> map = this.resolvers;
        synchronized (map) {
            r = this.resolvers.get(executor);
            if (r == null) {
                NameResolver<T> newResolver;
                try {
                    newResolver = this.newResolver(executor);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to create a new resolver", e);
                }
                this.resolvers.put(executor, newResolver);
                executor.terminationFuture().addListener((GenericFutureListener)new FutureListener<Object>(){

                    public void operationComplete(Future<Object> future) throws Exception {
                        NameResolverGroup.this.resolvers.remove(executor);
                        newResolver.close();
                    }
                });
                r = newResolver;
            }
        }
        return r;
    }

    protected abstract NameResolver<T> newResolver(EventExecutor var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NameResolver[] rArray;
        Map<EventExecutor, NameResolver<T>> map = this.resolvers;
        synchronized (map) {
            rArray = this.resolvers.values().toArray(new NameResolver[this.resolvers.size()]);
            this.resolvers.clear();
        }
        for (NameResolver r : rArray) {
            try {
                r.close();
            }
            catch (Throwable t) {
                logger.warn("Failed to close a resolver:", t);
            }
        }
    }
}

