/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.netty.resolver.dns.Cache;
import io.netty.resolver.dns.DefaultAuthoritativeDnsServerCache;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DefaultDnsCnameCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsCnameCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.ThreadLocalNameServerAddressStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DnsNameResolverBuilderTest {
    private static final EventLoopGroup GROUP = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
    private DnsNameResolverBuilder builder;
    private DnsNameResolver resolver;

    DnsNameResolverBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.builder = new DnsNameResolverBuilder(GROUP.next()).channelType(NioDatagramChannel.class);
    }

    @AfterEach
    void tearDown() {
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    @AfterAll
    static void shutdownEventLoopGroup() {
        GROUP.shutdownGracefully();
    }

    @Test
    void testDefaults() {
        this.resolver = this.builder.build();
        DnsNameResolverBuilderTest.checkDefaultDnsCache((DefaultDnsCache)this.resolver.resolveCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0, 0);
        DnsNameResolverBuilderTest.checkDefaultDnsCnameCache((DefaultDnsCnameCache)this.resolver.cnameCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0);
        DnsNameResolverBuilderTest.checkDefaultAuthoritativeDnsServerCache((DefaultAuthoritativeDnsServerCache)this.resolver.authoritativeDnsServerCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0);
        Assertions.assertThat((Object)this.resolver.queryDnsServerAddressStream()).isInstanceOf(ThreadLocalNameServerAddressStream.class);
    }

    @Test
    void testCustomDnsCacheDefaultTtl() {
        TestDnsCache testDnsCache = new TestDnsCache();
        this.resolver = this.builder.resolveCache((DnsCache)testDnsCache).build();
        Assertions.assertThat((Object)this.resolver.resolveCache()).isSameAs((Object)testDnsCache);
        DnsNameResolverBuilderTest.checkDefaultDnsCnameCache((DefaultDnsCnameCache)this.resolver.cnameCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0);
        DnsNameResolverBuilderTest.checkDefaultAuthoritativeDnsServerCache((DefaultAuthoritativeDnsServerCache)this.resolver.authoritativeDnsServerCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0);
    }

    @Test
    void testCustomDnsCacheCustomTtl() {
        TestDnsCache testDnsCache = new TestDnsCache();
        this.resolver = this.builder.resolveCache((DnsCache)testDnsCache).ttl(1, 2).negativeTtl(3).build();
        Assertions.assertThat((Object)this.resolver.resolveCache()).isSameAs((Object)testDnsCache);
        DnsNameResolverBuilderTest.checkDefaultDnsCnameCache((DefaultDnsCnameCache)this.resolver.cnameCache(), 2, 1);
        DnsNameResolverBuilderTest.checkDefaultAuthoritativeDnsServerCache((DefaultAuthoritativeDnsServerCache)this.resolver.authoritativeDnsServerCache(), 2, 1);
    }

    @Test
    void testCustomDnsCnameCacheDefaultTtl() {
        TestDnsCnameCache testDnsCnameCache = new TestDnsCnameCache();
        this.resolver = this.builder.cnameCache((DnsCnameCache)testDnsCnameCache).build();
        DnsNameResolverBuilderTest.checkDefaultDnsCache((DefaultDnsCache)this.resolver.resolveCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0, 0);
        Assertions.assertThat((Object)this.resolver.cnameCache()).isSameAs((Object)testDnsCnameCache);
        DnsNameResolverBuilderTest.checkDefaultAuthoritativeDnsServerCache((DefaultAuthoritativeDnsServerCache)this.resolver.authoritativeDnsServerCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0);
    }

    @Test
    void testCustomDnsCnameCacheCustomTtl() {
        TestDnsCnameCache testDnsCnameCache = new TestDnsCnameCache();
        this.resolver = this.builder.cnameCache((DnsCnameCache)testDnsCnameCache).ttl(1, 2).negativeTtl(3).build();
        DnsNameResolverBuilderTest.checkDefaultDnsCache((DefaultDnsCache)this.resolver.resolveCache(), 2, 1, 3);
        Assertions.assertThat((Object)this.resolver.cnameCache()).isSameAs((Object)testDnsCnameCache);
        DnsNameResolverBuilderTest.checkDefaultAuthoritativeDnsServerCache((DefaultAuthoritativeDnsServerCache)this.resolver.authoritativeDnsServerCache(), 2, 1);
    }

    @Test
    void testCustomAuthoritativeDnsServerCacheDefaultTtl() {
        TestAuthoritativeDnsServerCache testAuthoritativeDnsServerCache = new TestAuthoritativeDnsServerCache();
        this.resolver = this.builder.authoritativeDnsServerCache((AuthoritativeDnsServerCache)testAuthoritativeDnsServerCache).build();
        DnsNameResolverBuilderTest.checkDefaultDnsCache((DefaultDnsCache)this.resolver.resolveCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0, 0);
        DnsNameResolverBuilderTest.checkDefaultDnsCnameCache((DefaultDnsCnameCache)this.resolver.cnameCache(), Cache.MAX_SUPPORTED_TTL_SECS, 0);
        Assertions.assertThat((Object)this.resolver.authoritativeDnsServerCache()).isSameAs((Object)testAuthoritativeDnsServerCache);
    }

    @Test
    void testCustomAuthoritativeDnsServerCacheCustomTtl() {
        TestAuthoritativeDnsServerCache testAuthoritativeDnsServerCache = new TestAuthoritativeDnsServerCache();
        this.resolver = this.builder.authoritativeDnsServerCache((AuthoritativeDnsServerCache)testAuthoritativeDnsServerCache).ttl(1, 2).negativeTtl(3).build();
        DnsNameResolverBuilderTest.checkDefaultDnsCache((DefaultDnsCache)this.resolver.resolveCache(), 2, 1, 3);
        DnsNameResolverBuilderTest.checkDefaultDnsCnameCache((DefaultDnsCnameCache)this.resolver.cnameCache(), 2, 1);
        Assertions.assertThat((Object)this.resolver.authoritativeDnsServerCache()).isSameAs((Object)testAuthoritativeDnsServerCache);
    }

    @Test
    void disableQueryTimeoutWithZero() {
        this.resolver = this.builder.queryTimeoutMillis(0L).build();
        Assertions.assertThat((long)this.resolver.queryTimeoutMillis()).isEqualTo(0L);
    }

    private static void checkDefaultDnsCache(DefaultDnsCache dnsCache, int expectedMaxTtl, int expectedMinTtl, int expectedNegativeTtl) {
        Assertions.assertThat((int)dnsCache.maxTtl()).isEqualTo(expectedMaxTtl);
        Assertions.assertThat((int)dnsCache.minTtl()).isEqualTo(expectedMinTtl);
        Assertions.assertThat((int)dnsCache.negativeTtl()).isEqualTo(expectedNegativeTtl);
    }

    private static void checkDefaultDnsCnameCache(DefaultDnsCnameCache dnsCnameCache, int expectedMaxTtl, int expectedMinTtl) {
        Assertions.assertThat((int)dnsCnameCache.maxTtl()).isEqualTo(expectedMaxTtl);
        Assertions.assertThat((int)dnsCnameCache.minTtl()).isEqualTo(expectedMinTtl);
    }

    private static void checkDefaultAuthoritativeDnsServerCache(DefaultAuthoritativeDnsServerCache authoritativeDnsServerCache, int expectedMaxTtl, int expectedMinTtl) {
        Assertions.assertThat((int)authoritativeDnsServerCache.maxTtl()).isEqualTo(expectedMaxTtl);
        Assertions.assertThat((int)authoritativeDnsServerCache.minTtl()).isEqualTo(expectedMinTtl);
    }

    @Test
    void testCustomQueryDnsServerAddressStream() {
        TestQueryServerAddressStream queryAddressStream = new TestQueryServerAddressStream();
        this.resolver = this.builder.queryServerAddressStream((DnsServerAddressStream)queryAddressStream).build();
        Assertions.assertThat((Object)this.resolver.queryDnsServerAddressStream()).isSameAs((Object)queryAddressStream);
        this.resolver = this.builder.copy().build();
        Assertions.assertThat((Object)this.resolver.queryDnsServerAddressStream()).isSameAs((Object)queryAddressStream);
    }

    private static final class TestQueryServerAddressStream
    implements DnsServerAddressStream {
        private TestQueryServerAddressStream() {
        }

        public InetSocketAddress next() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public DnsServerAddressStream duplicate() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TestAuthoritativeDnsServerCache
    implements AuthoritativeDnsServerCache {
        private TestAuthoritativeDnsServerCache() {
        }

        public DnsServerAddressStream get(String hostname) {
            return null;
        }

        public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
        }

        public void clear() {
        }

        public boolean clear(String hostname) {
            return false;
        }
    }

    private static final class TestDnsCnameCache
    implements DnsCnameCache {
        private TestDnsCnameCache() {
        }

        public String get(String hostname) {
            return null;
        }

        public void cache(String hostname, String cname, long originalTtl, EventLoop loop) {
        }

        public void clear() {
        }

        public boolean clear(String hostname) {
            return false;
        }
    }

    private static final class TestDnsCache
    implements DnsCache {
        private TestDnsCache() {
        }

        public void clear() {
        }

        public boolean clear(String hostname) {
            return false;
        }

        public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additional) {
            return null;
        }

        public DnsCacheEntry cache(String hostname, DnsRecord[] additional, InetAddress address, long originalTtl, EventLoop loop) {
            return null;
        }

        public DnsCacheEntry cache(String hostname, DnsRecord[] additional, Throwable cause, EventLoop loop) {
            return null;
        }
    }
}

