/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import io.netty.pkitesting.Algorithms;
import io.netty.pkitesting.X509Bundle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

final class Signed {
    private final byte[] toBeSigned;
    private final String algorithmIdentifier;
    private final PrivateKey privateKey;

    Signed(byte[] toBeSigned, X509Bundle signer) {
        this(toBeSigned, signer.getCertificate().getSigAlgName(), signer.getKeyPair().getPrivate());
    }

    Signed(byte[] toBeSigned, String algorithmIdentifier, PrivateKey privateKey) {
        this.toBeSigned = Objects.requireNonNull(toBeSigned, "toBeSigned");
        this.algorithmIdentifier = Objects.requireNonNull(algorithmIdentifier, "algorithmIdentifier");
        this.privateKey = privateKey;
    }

    byte[] getEncoded() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Algorithms.signature(this.algorithmIdentifier);
        signature.initSign(this.privateKey);
        signature.update(this.toBeSigned);
        byte[] signatureBytes = signature.sign();
        try {
            return new DERSequence(new ASN1Encodable[]{ASN1Primitive.fromByteArray((byte[])this.toBeSigned), new AlgorithmIdentifier(new ASN1ObjectIdentifier(Algorithms.oidForAlgorithmName(this.algorithmIdentifier))), new DERBitString(signatureBytes)}).getEncoded("DER");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    InputStream toInputStream() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return new ByteArrayInputStream(this.getEncoded());
    }
}

