/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import io.netty.pkitesting.Algorithms;
import io.netty.pkitesting.GeneralNameUtils;
import io.netty.pkitesting.Signed;
import io.netty.pkitesting.X509Bundle;
import io.netty.util.internal.EmptyArrays;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;

public final class CertificateBuilder {
    static final String OID_X509_NAME_CONSTRAINTS = "2.5.29.30";
    static final String OID_PKIX_KP = "1.3.6.1.5.5.7.3";
    static final String OID_PKIX_KP_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    static final String OID_PKIX_KP_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    static final String OID_PKIX_KP_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    static final String OID_PKIX_KP_EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";
    static final String OID_PKIX_KP_TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    static final String OID_PKIX_KP_OCSP_SIGNING = "1.3.6.1.5.5.7.3.9";
    static final String OID_KERBEROS_KEY_PURPOSE_CLIENT_AUTH = "1.3.6.1.5.2.3.4";
    static final String OID_MICROSOFT_SMARTCARD_LOGIN = "1.3.6.1.4.1.311.20.2.2";
    private static final GeneralName[] EMPTY_GENERAL_NAMES = new GeneralName[0];
    private static final DistributionPoint[] EMPTY_DIST_POINTS = new DistributionPoint[0];
    private static final AlgorithmParameterSpec UNSUPPORTED_SPEC = new AlgorithmParameterSpec(){};
    SecureRandom random;
    Algorithm algorithm = Algorithm.ecp256;
    Instant notBefore = Instant.now().minus(1L, ChronoUnit.DAYS);
    Instant notAfter = Instant.now().plus(1L, ChronoUnit.DAYS);
    List<BuilderCallback> modifierCallbacks = new ArrayList<BuilderCallback>();
    List<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
    List<DistributionPoint> crlDistributionPoints = new ArrayList<DistributionPoint>();
    BigInteger serial;
    X500Principal subject;
    boolean isCertificateAuthority;
    OptionalInt pathLengthConstraint = OptionalInt.empty();
    PublicKey publicKey;
    Set<String> extendedKeyUsage = new TreeSet<String>();
    Extension keyUsage;

    public CertificateBuilder copy() {
        CertificateBuilder copy = new CertificateBuilder();
        copy.random = this.random;
        copy.algorithm = this.algorithm;
        copy.notBefore = this.notBefore;
        copy.notAfter = this.notAfter;
        copy.modifierCallbacks = new ArrayList<BuilderCallback>(this.modifierCallbacks);
        copy.subjectAlternativeNames = new ArrayList<GeneralName>(this.subjectAlternativeNames);
        copy.crlDistributionPoints = new ArrayList<DistributionPoint>(this.crlDistributionPoints);
        copy.serial = this.serial;
        copy.subject = this.subject;
        copy.isCertificateAuthority = this.isCertificateAuthority;
        copy.pathLengthConstraint = this.pathLengthConstraint;
        copy.publicKey = this.publicKey;
        copy.keyUsage = this.keyUsage;
        copy.extendedKeyUsage = new TreeSet<String>(this.extendedKeyUsage);
        return copy;
    }

    public CertificateBuilder secureRandom(SecureRandom secureRandom) {
        this.random = Objects.requireNonNull(secureRandom);
        return this;
    }

    public CertificateBuilder notBefore(Instant instant) {
        this.notBefore = Objects.requireNonNull(instant);
        return this;
    }

    public CertificateBuilder notAfter(Instant instant) {
        this.notAfter = Objects.requireNonNull(instant);
        return this;
    }

    public CertificateBuilder serial(BigInteger serial) {
        this.serial = serial;
        return this;
    }

    public CertificateBuilder subject(String fqdn) {
        this.subject = new X500Principal(Objects.requireNonNull(fqdn));
        return this;
    }

    public CertificateBuilder subject(X500Principal name) {
        this.subject = Objects.requireNonNull(name);
        return this;
    }

    public CertificateBuilder addSanOtherName(String typeOid, byte[] encodedValue) {
        this.subjectAlternativeNames.add(GeneralNameUtils.otherName(typeOid, encodedValue));
        return this;
    }

    public CertificateBuilder addSanRfc822Name(String name) {
        this.subjectAlternativeNames.add(GeneralNameUtils.rfc822Name(name));
        return this;
    }

    public CertificateBuilder addSanDnsName(String dns) {
        if (dns.trim().isEmpty()) {
            throw new IllegalArgumentException("Blank DNS SANs are forbidden by RFC 5280, Section 4.2.1.6.");
        }
        this.subjectAlternativeNames.add(GeneralNameUtils.dnsName(dns));
        return this;
    }

    public CertificateBuilder addSanDirectoryName(String dirName) {
        this.subjectAlternativeNames.add(GeneralNameUtils.directoryName(dirName));
        return this;
    }

    public CertificateBuilder addSanUriName(String uri) throws URISyntaxException {
        this.subjectAlternativeNames.add(GeneralNameUtils.uriName(uri));
        return this;
    }

    public CertificateBuilder addSanUriName(URI uri) {
        this.subjectAlternativeNames.add(GeneralNameUtils.uriName(uri));
        return this;
    }

    public CertificateBuilder addSanIpAddress(String ipAddress) {
        this.subjectAlternativeNames.add(GeneralNameUtils.ipAddress(ipAddress));
        return this;
    }

    public CertificateBuilder addSanIpAddress(InetAddress ipAddress) {
        this.subjectAlternativeNames.add(GeneralNameUtils.ipAddress(ipAddress.getHostAddress()));
        return this;
    }

    public CertificateBuilder addSanRegisteredId(String oid) {
        this.subjectAlternativeNames.add(GeneralNameUtils.registeredId(oid));
        return this;
    }

    public CertificateBuilder addCrlDistributionPoint(URI uri) {
        GeneralName fullName = GeneralNameUtils.uriName(uri);
        this.crlDistributionPoints.add(new DistributionPoint(new DistributionPointName(new GeneralNames(fullName)), null, null));
        return this;
    }

    public CertificateBuilder addCrlDistributionPoint(URI uri, X500Principal issuer) {
        GeneralName fullName = GeneralNameUtils.uriName(uri);
        GeneralName issuerName = GeneralNameUtils.directoryName(issuer);
        this.crlDistributionPoints.add(new DistributionPoint(new DistributionPointName(new GeneralNames(fullName)), null, new GeneralNames(issuerName)));
        return this;
    }

    public CertificateBuilder setIsCertificateAuthority(boolean isCA) {
        this.isCertificateAuthority = isCA;
        return this;
    }

    public CertificateBuilder setPathLengthConstraint(OptionalInt pathLengthConstraint) {
        this.pathLengthConstraint = Objects.requireNonNull(pathLengthConstraint, "pathLengthConstraint");
        return this;
    }

    public CertificateBuilder algorithm(Algorithm algorithm) {
        Objects.requireNonNull(algorithm, "algorithm");
        if (algorithm.parameterSpec == UNSUPPORTED_SPEC) {
            throw new UnsupportedOperationException("This algorithm is not supported: " + (Object)((Object)algorithm));
        }
        this.algorithm = algorithm;
        return this;
    }

    public CertificateBuilder ecp256() {
        return this.algorithm(Algorithm.ecp256);
    }

    public CertificateBuilder rsa2048() {
        return this.algorithm(Algorithm.rsa2048);
    }

    public CertificateBuilder publicKey(PublicKey key) {
        this.publicKey = key;
        return this;
    }

    private CertificateBuilder addExtension(String identifierOid, boolean critical, byte[] value) {
        Objects.requireNonNull(identifierOid, "identifierOid");
        Objects.requireNonNull(value, "value");
        this.modifierCallbacks.add(builder -> builder.addExtension(new Extension(new ASN1ObjectIdentifier(identifierOid), critical, value)));
        return this;
    }

    public CertificateBuilder addExtensionOctetString(String identifierOID, boolean critical, byte[] contents) {
        Objects.requireNonNull(identifierOID, "identifierOID");
        Objects.requireNonNull(contents, "contents");
        this.modifierCallbacks.add(builder -> builder.addExtension(new Extension(new ASN1ObjectIdentifier(identifierOID), critical, contents)));
        return this;
    }

    public CertificateBuilder addExtensionUtf8String(String identifierOID, boolean critical, String value) {
        try {
            return this.addExtension(identifierOID, critical, new DERUTF8String(value).getEncoded("DER"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CertificateBuilder addExtensionAsciiString(String identifierOID, boolean critical, String value) {
        try {
            return this.addExtension(identifierOID, critical, new DERIA5String(value).getEncoded("DER"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CertificateBuilder setKeyUsage(boolean critical, KeyUsage ... keyUsages) {
        int maxBit = 0;
        for (KeyUsage usage : keyUsages) {
            maxBit = Math.max(usage.bitId, maxBit);
        }
        boolean[] bits = new boolean[maxBit + 1];
        for (KeyUsage usage : keyUsages) {
            bits[((KeyUsage)usage).bitId] = true;
        }
        int padding = 8 - bits.length % 8;
        int lenBytes = bits.length / 8 + 1;
        if (padding == 8) {
            padding = 0;
            --lenBytes;
        }
        byte[] bytes = new byte[lenBytes];
        for (int i = 0; i < bits.length; ++i) {
            if (!bits[i]) continue;
            int byteIndex = i / 8;
            int bitIndex = i % 8;
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] | (byte)(128 >>> bitIndex));
        }
        try {
            this.keyUsage = new Extension(Extension.keyUsage, critical, new DERBitString(bytes, padding).getEncoded("DER"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public CertificateBuilder addExtendedKeyUsage(String oid) {
        this.extendedKeyUsage.add(oid);
        return this;
    }

    public CertificateBuilder addExtendedKeyUsage(ExtendedKeyUsage keyUsage) {
        this.extendedKeyUsage.add(keyUsage.getOid());
        return this;
    }

    public CertificateBuilder addExtendedKeyUsageServerAuth() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.PKIX_KP_SERVER_AUTH);
    }

    public CertificateBuilder addExtendedKeyUsageClientAuth() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.PKIX_KP_CLIENT_AUTH);
    }

    public CertificateBuilder addExtendedKeyUsageCodeSigning() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.PKIX_KP_CODE_SIGNING);
    }

    public CertificateBuilder addExtendedKeyUsageEmailProtection() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.PKIX_KP_EMAIL_PROTECTION);
    }

    public CertificateBuilder addExtendedKeyUsageTimeStamping() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.PKIX_KP_TIME_STAMPING);
    }

    public CertificateBuilder addExtendedKeyUsageOcspSigning() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.PKIX_KP_OCSP_SIGNING);
    }

    public CertificateBuilder addExtendedKeyUsageKerberosClientAuth() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.KERBEROS_KEY_PURPOSE_CLIENT_AUTH);
    }

    public CertificateBuilder addExtendedKeyUsageMicrosoftSmartcardLogin() {
        return this.addExtendedKeyUsage(ExtendedKeyUsage.MICROSOFT_SMARTCARD_LOGIN);
    }

    public X509Bundle buildSelfSigned() throws Exception {
        if (this.publicKey != null) {
            throw new IllegalStateException("Cannot create a self-signed certificate with a public key from a CSR.");
        }
        KeyPair keyPair = this.generateKeyPair();
        V3TBSCertificateGenerator generator = this.createCertBuilder(this.subject, this.subject, keyPair, this.algorithm.signatureType);
        this.addExtensions(generator);
        Signed signed = new Signed(CertificateBuilder.tbsCertToBytes(generator), this.algorithm.signatureType, keyPair.getPrivate());
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(signed.toInputStream());
        return X509Bundle.fromRootCertificateAuthority(cert, keyPair);
    }

    public X509Bundle buildIssuedBy(X509Bundle issuerBundle) throws Exception {
        String issuerSignAlgorithm = CertificateBuilder.preferredSignatureAlgorithm(issuerBundle.getCertificate().getPublicKey());
        return this.buildIssuedBy(issuerBundle, issuerSignAlgorithm);
    }

    public X509Bundle buildIssuedBy(X509Bundle issuerBundle, String signAlg) throws Exception {
        KeyPair keyPair = this.publicKey == null ? this.generateKeyPair() : new KeyPair(this.publicKey, null);
        X500Principal issuerPrincipal = issuerBundle.getCertificate().getSubjectX500Principal();
        V3TBSCertificateGenerator generator = this.createCertBuilder(issuerPrincipal, this.subject, keyPair, signAlg);
        this.addExtensions(generator);
        PrivateKey issuerPrivateKey = issuerBundle.getKeyPair().getPrivate();
        if (issuerPrivateKey == null) {
            throw new IllegalArgumentException("Cannot sign certificate with issuer bundle that does not have a private key.");
        }
        Signed signed = new Signed(CertificateBuilder.tbsCertToBytes(generator), signAlg, issuerPrivateKey);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(signed.toInputStream());
        X509Certificate[] issuerPath = issuerBundle.getCertificatePath();
        X509Certificate[] path = new X509Certificate[issuerPath.length + 1];
        path[0] = cert;
        System.arraycopy(issuerPath, 0, path, 1, issuerPath.length);
        return X509Bundle.fromCertificatePath(path, issuerBundle.getRootCertificate(), keyPair);
    }

    private static String preferredSignatureAlgorithm(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsa = (RSAPublicKey)key;
            if (rsa.getModulus().bitLength() < 4096) {
                return "SHA256withRSA";
            }
            return "SHA384withRSA";
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)key;
            int size = ec.getW().getAffineX().bitLength();
            if (size <= 256) {
                return "SHA256withECDSA";
            }
            if (size <= 384) {
                return "SHA384withECDSA";
            }
            return "SHA512withECDSA";
        }
        if (key instanceof DSAPublicKey) {
            throw new IllegalArgumentException("DSA keys are not supported because they are obsolete.");
        }
        String keyAlgorithm = key.getAlgorithm();
        if ("Ed25519".equals(keyAlgorithm) || "1.3.101.112".equals(keyAlgorithm)) {
            return "Ed25519";
        }
        if ("Ed448".equals(keyAlgorithm) || "1.3.101.113".equals(keyAlgorithm)) {
            return "Ed448";
        }
        if ("EdDSA".equals(keyAlgorithm)) {
            byte[] encoded = key.getEncoded();
            if (encoded.length <= 44) {
                return "Ed25519";
            }
            if (encoded.length <= 69) {
                return "Ed448";
            }
        }
        throw new IllegalArgumentException("Don't know what signature algorithm is best for " + key);
    }

    private KeyPair generateKeyPair() throws GeneralSecurityException {
        return this.algorithm.generateKeyPair(this.getSecureRandom());
    }

    private V3TBSCertificateGenerator createCertBuilder(X500Principal issuer, X500Principal subject, KeyPair keyPair, String signAlg) {
        BigInteger serial = this.serial != null ? this.serial : new BigInteger(159, this.getSecureRandom());
        PublicKey pubKey = keyPair.getPublic();
        V3TBSCertificateGenerator generator = new V3TBSCertificateGenerator();
        generator.setIssuer(X500Name.getInstance((Object)issuer.getEncoded()));
        if (subject != null) {
            generator.setSubject(X500Name.getInstance((Object)subject.getEncoded()));
        }
        generator.setSerialNumber(new ASN1Integer(serial));
        generator.setSignature(new AlgorithmIdentifier(new ASN1ObjectIdentifier(Algorithms.oidForAlgorithmName(signAlg))));
        generator.setStartDate(new Time(Date.from(this.notBefore)));
        generator.setEndDate(new Time(Date.from(this.notAfter)));
        generator.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        return generator;
    }

    private static byte[] tbsCertToBytes(V3TBSCertificateGenerator generator) {
        try {
            return generator.generateTBSCertificate().getEncoded("DER");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private SecureRandom getSecureRandom() {
        SecureRandom rng = this.random;
        if (rng == null) {
            rng = SecureRandomHolder.RANDOM;
        }
        return rng;
    }

    private void addExtensions(V3TBSCertificateGenerator tbsCert) throws Exception {
        ExtensionsGenerator generator = new ExtensionsGenerator();
        if (this.isCertificateAuthority) {
            BasicConstraints basicConstraints = this.pathLengthConstraint.isPresent() ? new BasicConstraints(this.pathLengthConstraint.getAsInt()) : new BasicConstraints(true);
            byte[] basicConstraintsBytes = basicConstraints.getEncoded("DER");
            generator.addExtension(new Extension(Extension.basicConstraints, true, basicConstraintsBytes));
        }
        if (this.keyUsage != null) {
            generator.addExtension(this.keyUsage);
        }
        if (!this.extendedKeyUsage.isEmpty()) {
            KeyPurposeId[] usages = new KeyPurposeId[this.extendedKeyUsage.size()];
            String[] usagesStrings = this.extendedKeyUsage.toArray(EmptyArrays.EMPTY_STRINGS);
            for (int i = 0; i < usagesStrings.length; ++i) {
                usages[i] = KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(usagesStrings[i]));
            }
            byte[] der = new org.bouncycastle.asn1.x509.ExtendedKeyUsage(usages).getEncoded("DER");
            generator.addExtension(new Extension(Extension.extendedKeyUsage, false, der));
        }
        if (!this.subjectAlternativeNames.isEmpty()) {
            byte[] result;
            boolean critical = this.subject.getName().isEmpty();
            GeneralNames generalNames = new GeneralNames(this.subjectAlternativeNames.toArray(EMPTY_GENERAL_NAMES));
            try {
                result = generalNames.getEncoded("DER");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            generator.addExtension(new Extension(Extension.subjectAlternativeName, critical, result));
        }
        if (!this.crlDistributionPoints.isEmpty()) {
            generator.addExtension(Extension.create((ASN1ObjectIdentifier)Extension.cRLDistributionPoints, (boolean)false, (ASN1Encodable)new CRLDistPoint(this.crlDistributionPoints.toArray(EMPTY_DIST_POINTS))));
        }
        for (BuilderCallback callback : this.modifierCallbacks) {
            callback.modify(generator);
        }
        if (!generator.isEmpty()) {
            tbsCert.setExtensions(generator.generate());
        }
    }

    private static final class SecureRandomHolder {
        private static final SecureRandom RANDOM = new SecureRandom();

        private SecureRandomHolder() {
        }
    }

    @FunctionalInterface
    private static interface BuilderCallback {
        public void modify(ExtensionsGenerator var1) throws Exception;
    }

    public static enum ExtendedKeyUsage {
        PKIX_KP_SERVER_AUTH("1.3.6.1.5.5.7.3.1"),
        PKIX_KP_CLIENT_AUTH("1.3.6.1.5.5.7.3.2"),
        PKIX_KP_CODE_SIGNING("1.3.6.1.5.5.7.3.3"),
        PKIX_KP_EMAIL_PROTECTION("1.3.6.1.5.5.7.3.4"),
        PKIX_KP_TIME_STAMPING("1.3.6.1.5.5.7.3.8"),
        PKIX_KP_OCSP_SIGNING("1.3.6.1.5.5.7.3.9"),
        KERBEROS_KEY_PURPOSE_CLIENT_AUTH("1.3.6.1.5.2.3.4"),
        MICROSOFT_SMARTCARD_LOGIN("1.3.6.1.4.1.311.20.2.2");

        private final String oid;

        private ExtendedKeyUsage(String oid) {
            this.oid = oid;
        }

        public String getOid() {
            return this.oid;
        }
    }

    public static enum KeyUsage {
        digitalSignature(0),
        contentCommitment(1),
        keyEncipherment(2),
        dataEncipherment(3),
        keyAgreement(4),
        keyCertSign(5),
        cRLSign(6),
        encipherOnly(7),
        decipherOnly(8);

        private final int bitId;

        private KeyUsage(int bitId) {
            this.bitId = bitId;
        }
    }

    public static enum Algorithm {
        ecp256("EC", new ECGenParameterSpec("secp256r1"), "SHA256withECDSA"),
        ecp384("EC", new ECGenParameterSpec("secp384r1"), "SHA384withECDSA"),
        rsa2048("RSA", new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), "SHA256withRSA"),
        rsa3072("RSA", new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4), "SHA256withRSA"),
        rsa4096("RSA", new RSAKeyGenParameterSpec(4096, RSAKeyGenParameterSpec.F4), "SHA384withRSA"),
        rsa8192("RSA", new RSAKeyGenParameterSpec(8192, RSAKeyGenParameterSpec.F4), "SHA384withRSA"),
        ed25519("Ed25519", Algorithm.namedParameterSpec("Ed25519"), "Ed25519"),
        ed448("Ed448", Algorithm.namedParameterSpec("Ed448"), "Ed448"),
        mlDsa44("ML-DSA", Algorithm.namedParameterSpec("ML-DSA-44"), "ML-DSA-44"),
        mlDsa65("ML-DSA", Algorithm.namedParameterSpec("ML-DSA-65"), "ML-DSA-65"),
        mlDsa87("ML-DSA", Algorithm.namedParameterSpec("ML-DSA-87"), "ML-DSA-87");

        final String keyType;
        final AlgorithmParameterSpec parameterSpec;
        final String signatureType;

        private Algorithm(String keyType, AlgorithmParameterSpec parameterSpec, String signatureType) {
            this.keyType = keyType;
            this.parameterSpec = parameterSpec;
            this.signatureType = signatureType;
        }

        private static AlgorithmParameterSpec namedParameterSpec(String name) {
            try {
                Class<?> cls = Class.forName("java.security.spec.NamedParameterSpec");
                return (AlgorithmParameterSpec)cls.getConstructor(String.class).newInstance(name);
            }
            catch (Exception e) {
                if ("Ed25519".equals(name)) {
                    return new EdDSAParameterSpec("Ed25519");
                }
                if ("Ed448".equals(name)) {
                    return new EdDSAParameterSpec("Ed448");
                }
                return UNSUPPORTED_SPEC;
            }
        }

        public KeyPair generateKeyPair(SecureRandom secureRandom) throws GeneralSecurityException {
            Objects.requireNonNull(secureRandom, "secureRandom");
            if (this.parameterSpec == UNSUPPORTED_SPEC) {
                throw new UnsupportedOperationException("This algorithm is not supported: " + (Object)((Object)this));
            }
            if (this == mlDsa44 || this == mlDsa65 || this == mlDsa87) {
                return this.genMlDsaKeyPair(secureRandom);
            }
            return this.genKeyPair(secureRandom);
        }

        private KeyPair genMlDsaKeyPair(SecureRandom secureRandom) throws GeneralSecurityException {
            KeyPair keyPair = this.genKeyPair(secureRandom);
            return new KeyPair(keyPair.getPublic(), keyPair.getPrivate());
        }

        private KeyPair genKeyPair(SecureRandom secureRandom) throws GeneralSecurityException {
            KeyPairGenerator keyGen = Algorithms.keyPairGenerator(this.keyType, this.parameterSpec, secureRandom);
            return keyGen.generateKeyPair();
        }

        public boolean isSupported() {
            return this.parameterSpec != UNSUPPORTED_SPEC;
        }
    }
}

