/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=2)
@Warmup(iterations=10, time=400, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=400, timeUnit=TimeUnit.MILLISECONDS)
public class VarintDecodingBenchmark
extends AbstractMicrobenchmark {
    private static final int SEED = 0;
    @Param(value={"1", "128", "128000"})
    int inputs;
    @Param
    InputDistribution inputDistribution;
    ByteBuf[] data;
    int index;

    @Setup
    public void init() {
        ByteBuf[] dataSet;
        switch (this.inputDistribution) {
            case SMALL: {
                dataSet = new ByteBuf[]{VarintDecodingBenchmark.generateData(1, 1), VarintDecodingBenchmark.generateData(2, 2), VarintDecodingBenchmark.generateData(3, 3)};
                break;
            }
            case LARGE: {
                dataSet = new ByteBuf[]{VarintDecodingBenchmark.generateData(5, 5)};
                if (this.inputs <= 1) break;
                System.exit(1);
                break;
            }
            case MEDIUM: {
                dataSet = new ByteBuf[]{VarintDecodingBenchmark.generateData(1, 5), VarintDecodingBenchmark.generateData(2, 5), VarintDecodingBenchmark.generateData(3, 5), VarintDecodingBenchmark.generateData(4, 5)};
                break;
            }
            case ALL: {
                dataSet = new ByteBuf[]{VarintDecodingBenchmark.generateData(1, 1), VarintDecodingBenchmark.generateData(2, 2), VarintDecodingBenchmark.generateData(3, 3), VarintDecodingBenchmark.generateData(1, 5), VarintDecodingBenchmark.generateData(2, 5), VarintDecodingBenchmark.generateData(3, 5), VarintDecodingBenchmark.generateData(4, 5), VarintDecodingBenchmark.generateData(5, 5)};
                break;
            }
            default: {
                throw new RuntimeException("Unknown distribution");
            }
        }
        this.data = new ByteBuf[this.inputs];
        Random rnd = new Random(0L);
        for (int i = 0; i < this.inputs; ++i) {
            this.data[i] = dataSet[rnd.nextInt(dataSet.length)];
        }
        this.index = 0;
    }

    public static ByteBuf generateData(int varintLength, int capacity) {
        byte[] bytes = new byte[capacity];
        for (int i = 0; i < varintLength - 1; ++i) {
            bytes[i] = -106;
        }
        bytes[varintLength - 1] = 1;
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    public ByteBuf nextData() {
        ++this.index;
        if (this.index == this.data.length) {
            this.index = 0;
        }
        return this.data[this.index].resetReaderIndex();
    }

    @Benchmark
    public int oldReadRawVarint32() {
        return VarintDecodingBenchmark.oldReadRawVarint32(this.nextData());
    }

    @Benchmark
    public int readRawVarint32() {
        return ProtobufVarint32FrameDecoder.readRawVarint32((ByteBuf)this.nextData());
    }

    private static int oldReadRawVarint32(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if (!buffer.isReadable()) {
                buffer.resetReaderIndex();
                return 0;
            }
            tmp = buffer.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if (!buffer.isReadable()) {
                    buffer.resetReaderIndex();
                    return 0;
                }
                tmp = buffer.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    if (!buffer.isReadable()) {
                        buffer.resetReaderIndex();
                        return 0;
                    }
                    tmp = buffer.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    public static enum InputDistribution {
        SMALL,
        LARGE,
        MEDIUM,
        ALL;

    }
}

