/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.text.DecimalFormat;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.profile.LinuxPerfNormProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.ProfilerConfig;

@BenchmarkMode(value={Mode.Throughput})
@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class HttpStatusValueOfBenchmark
extends AbstractMicrobenchmark {
    private static final SplittableRandom random = new SplittableRandom();
    private static final DecimalFormat df = new DecimalFormat("##.##%");
    private static final int[] data_1300 = new int[1300];
    private static final int[] data_2600 = new int[2600];
    private static final int[] data_5300 = new int[5300];
    private static final int[] data_11000 = new int[11000];
    private static final int[] data_23000 = new int[23000];
    private static final boolean ENABLE_POLLUTE = false;

    @Setup(value=Level.Invocation)
    public void setup(Blackhole bh, BenchmarkParams benchmarkParams) {
        switch (benchmarkParams.getOpsPerInvocation()) {
            case 1300: {
                HttpStatusValueOfBenchmark.polluteBranchIfEnabled(bh, data_1300);
                HttpStatusValueOfBenchmark.fillBenchMarkData(data_1300);
                break;
            }
            case 2600: {
                HttpStatusValueOfBenchmark.polluteBranchIfEnabled(bh, data_2600);
                HttpStatusValueOfBenchmark.fillBenchMarkData(data_2600);
                break;
            }
            case 5300: {
                HttpStatusValueOfBenchmark.polluteBranchIfEnabled(bh, data_5300);
                HttpStatusValueOfBenchmark.fillBenchMarkData(data_5300);
                break;
            }
            case 11000: {
                HttpStatusValueOfBenchmark.polluteBranchIfEnabled(bh, data_11000);
                HttpStatusValueOfBenchmark.fillBenchMarkData(data_11000);
                break;
            }
            case 23000: {
                HttpStatusValueOfBenchmark.polluteBranchIfEnabled(bh, data_23000);
                HttpStatusValueOfBenchmark.fillBenchMarkData(data_23000);
            }
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=1300)
    public void valueOf_1300(Blackhole bh) {
        for (int code : data_1300) {
            bh.consume((Object)HttpStatusClass.valueOf((int)code));
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=2600)
    public void valueOf_2600(Blackhole bh) {
        for (int code : data_2600) {
            bh.consume((Object)HttpStatusClass.valueOf((int)code));
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=5300)
    public void valueOf_5300(Blackhole bh) {
        for (int code : data_5300) {
            bh.consume((Object)HttpStatusClass.valueOf((int)code));
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=11000)
    public void valueOf_11000(Blackhole bh) {
        for (int code : data_11000) {
            bh.consume((Object)HttpStatusClass.valueOf((int)code));
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=23000)
    public void valueOf_23000(Blackhole bh) {
        for (int code : data_23000) {
            bh.consume((Object)HttpStatusClass.valueOf((int)code));
        }
    }

    public HttpStatusValueOfBenchmark() {
        super(true);
    }

    private static void polluteBranchIfEnabled(Blackhole bh, int[] polluteData) {
    }

    private static void fillBenchMarkData(int[] benchMarkData) {
        double c1x = 0.0;
        double c2x = 0.0;
        double c3x = 0.0;
        double c4x = 0.0;
        double c5x = 0.0;
        double c6x = 0.0;
        int i = 0;
        while (i < benchMarkData.length) {
            int code = random.nextInt(0, 100);
            if (code < 38) {
                benchMarkData[i++] = random.nextInt(100, 200);
                c1x += 1.0;
                continue;
            }
            if (code < 68) {
                benchMarkData[i++] = random.nextInt(200, 300);
                c2x += 1.0;
                continue;
            }
            if (code < 83) {
                benchMarkData[i++] = random.nextInt(300, 400);
                c3x += 1.0;
                continue;
            }
            if (code < 93) {
                benchMarkData[i++] = random.nextInt(400, 500);
                c4x += 1.0;
                continue;
            }
            if (code < 98) {
                benchMarkData[i++] = random.nextInt(500, 600);
                c5x += 1.0;
                continue;
            }
            benchMarkData[i++] = random.nextInt(-50, 50);
            c6x += 1.0;
        }
    }

    private static void fillPolluteData(int[] polluteData) {
        double c1x = 0.0;
        double c2x = 0.0;
        double c3x = 0.0;
        double c4x = 0.0;
        double c5x = 0.0;
        double c6x = 0.0;
        int i = 0;
        while (i < polluteData.length) {
            int code = random.nextInt(0, 96);
            if (code < 16) {
                polluteData[i++] = random.nextInt(100, 200);
                c1x += 1.0;
                continue;
            }
            if (code < 32) {
                polluteData[i++] = random.nextInt(200, 300);
                c2x += 1.0;
                continue;
            }
            if (code < 48) {
                polluteData[i++] = random.nextInt(300, 400);
                c3x += 1.0;
                continue;
            }
            if (code < 64) {
                polluteData[i++] = random.nextInt(400, 500);
                c4x += 1.0;
                continue;
            }
            if (code < 80) {
                polluteData[i++] = random.nextInt(500, 600);
                c5x += 1.0;
                continue;
            }
            polluteData[i++] = random.nextInt(-50, 50);
            c6x += 1.0;
        }
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        Class<LinuxPerfNormProfiler> profilerClass = LinuxPerfNormProfiler.class;
        try {
            ProfilerFactory.getProfilerOrException((ProfilerConfig)new ProfilerConfig(profilerClass.getCanonicalName()));
        }
        catch (ProfilerException t) {
            return super.newOptionsBuilder();
        }
        return super.newOptionsBuilder().addProfiler(profilerClass);
    }

    private static void printCodePercentage(String desc, int length, double c1x, double c2x, double c3x, double c4x, double c5x, double c6x) {
        System.out.println("\n" + desc + "===>INFORMATIONAL:" + df.format(c1x / (double)length) + ", SUCCESS:" + df.format(c2x / (double)length) + ", REDIRECTION:" + df.format(c3x / (double)length) + ", CLIENT_ERROR:" + df.format(c4x / (double)length) + ", SERVER_ERROR:" + df.format(c5x / (double)length) + ", UNKNOWN:" + df.format(c6x / (double)length));
    }
}

